#ifndef squeezster_H
#define squeezster_H

#include <algorithm>
#include <QtNetwork>
#include <QHash>
#include <QList>
#include <QVariant>
#include <QMainWindow>
#include <QtGui>
#include <QTcpSocket>
#include <QUdpSocket>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QAuthenticator>
#include <QListWidgetItem>
#include <QTreeWidgetItem>
#include <QUrl>
#include <QTimer>
#include <QStringList>
#include <QFontMetrics>
#include <QSettings>
#include <QButtonGroup>
#include <QCheckBox>
//#include <qsysteminfo.h>
//#include <QSystemInfo>
#include <QSystemScreenSaver>
#include "connectiondialog.h"
#include "optionsdialog.h"
#include "libraryviewdialog.h"
#include "woldialog.h"
#include "squeezeresponse.h"
#include "xmltreeitem.h"
#include "xmllistitem.h"
#include "squeezster_icons.h"
#include "pushbuttonnetworkrequest.h"
#include "listwidgetitemnetworkrequest.h"
#include "treewidgetitemnetworkrequest.h"
#include "usersettings.h"
#include "metatypes.h"
#include "squeezstercommon.h"
#include "squeezeenv.h"
#include "squeezeplayer.h"


// Debug configuration:
//#define QT_NO_DEBUG
//#define QT_DEBUG
#define INSTALLMSGHANDLER
//#define NODEBUG
//#define DEBUGTOFILE
//#define DEBUGTOSTDERR

// Constants;
#define NORMALSCREENOFFSET 46
#define SUBSCRIBEINTERVAL 20
#define PROGRESSINTERVAL 2000
#define RESPONSEINTERVAL 300
#define REINITDELAY 5000
#define ITEMSELECTTIME 500
#define MAXITEMSPERREQUEST 100
#define MAXTREEITEMSPERREQUEST 5000
#define DISKCACHESIZE 16384*16
#define MAXCONNECTTRIES 3
#define DISCOVERYPORT_SC 3483
#define DISCOVERYPORT_CS 3483


#define STATUSTAGS "tags:alsdxK"
#define ALBUMTAGS "tags:ailjce"
#define IDTAGS "tags:pse"
#define DUMMYPLAYERNAME "SqueezsterDummyPlayer123"

QTM_USE_NAMESPACE

namespace Ui {
    class squeezster;
}


class squeezster : public QMainWindow,squeezstercommon,squeezeEnv,UserSettings
{
    Q_OBJECT

public:
    explicit squeezster(QWidget *parent = 0);
    ~squeezster();

signals:
    void playerStatusUpdated(squeezePlayer*);
    void activePlayerUpdated(squeezePlayer*);
    void pixmapDone();
    void initDone();

private:
    Ui::squeezster *ui;

    static const int xmlItemCol = 0;
    static const int httpObjectVariant = 1024;
    enum xmlListFlags {noUpdate,updateIcons};

    QSystemScreenSaver *screenSaverInhibiter;
    UserSettings settings;
    //QAuthenticator httpAuthent;
    connectionDialog *connectionUI;
    QTcpSocket *tcpSocket;
    QUdpSocket *serverUdpSocket;
    QUdpSocket *clientUdpSocket;
    QTextStream *inout;
    QTextStream *inTS;
    QTextStream *outTS;
    QTimer progressTimer;
    QTimer itemSelectTimer;
    QListWidgetItem *itemPressed;
    QTreeWidgetItem *pressedTreeItem;
    quint16 connectTries;

    QNetworkSession *networkSession;
    QNetworkAccessManager *networkManager;
    QNetworkConfigurationManager manager;
    QNetworkDiskCache *diskCache;
    quint16 screenMode;

    squeezeResponse *myResponse;
    squeezeEnv     mySqueezeEnv;
    QVariant treeItemParent;
    QVariant listItemParent;
    QVariant itemSelected;

    QVariantHash xmlBrowserHash;
    QHash<QString,bool> responseWhitelist;
    QHash<QString,bool> responseBlacklist;

    bool loadAlbumsBusy;
    bool albumsInitDone;
    bool musicFolderInitDone;
    bool pixmapBusy;
    QStringList busyList;
    QVariantMap httpGetMap;
    QList<QVariant*> pixmapDLList;
    QList<QUrl*> pixmapUrl;

    QIcon bulletIcon,smallBulletIcon,plusIcon,minusIcon,powerIcon,playIcon,pauseIcon,stopIcon;
    QIcon rewIcon,fwdIcon,noteIcon;
    QIcon emptyAlbumArtIcon;
    QIcon largeEmptyAlbumArtIcon;
    QIcon smallEmptyAlbumArtIcon;

    QString albumartsuffix;

    void updateStatus(squeezePlayer *player, QStringList *parameters);
    void updateRadiosApps(QString command, QStringList *parameters);
    //void updateMixer(squeezePlayer *player, QStringList *parameters);
    void queryStatus(squeezePlayer *player, bool subscribeEnable=false);

    void writeSettings(const UserSettings newSettings);
    void readSettings(UserSettings &newSettings);


private slots:
    void startApp(bool isOnline=true);
    void constructConnDialog();
//    void constructWOLDialog();
    void screensaverInhibitSlot(bool ssInhibit);
    void largeAlbumIconsSlot(bool largeAlbumIcons);
    bool requestConnect();
    void requestConnect(const UserSettings &newSettings);
    void httpAuthentSlot(QNetworkReply* networkReply, QAuthenticator* authenticator);
    void initEnvironment();
    void reInitEnvironment(int delay=REINITDELAY);
    void initUI();
    void updateNowPlayingIcons();
    void slotOptions();
    void slotMusicLibraryView();
    void downloadImage(QTreeWidgetItem* item, QString url);
    void downloadImage(xmlListItem* item, QString url);
    void downloadImage(QPushButton* item, QString url);
    void downloadAlbumImage(xmlListItem* item, QString id, UserSettings settings);
    void downloadAlbumImage(xmlListItem* item);

    void pixmapDownloaded(QNetworkReply *reply);


    void slotTabWidgetCurrentChanged(int currentIndex);
    void initAlbumsList();
    void initTitlesTree();
    void initArtistsTree();
    void showAlbums();
    void showTitles();
    void showArtists();
    void showPlaylists();

    void setAlbumsListIconView(bool iconView);
    void treeContextMenuHandler(QPoint point);
    void listContextMenuHandler(QPoint point);

    void displayError(QAbstractSocket::SocketError socketError);
    void incrementScreenMode();
    void setupScreenMode();
    void isBusy(const QString busyString=QString());
    void sessionOpened();
    void updateUI(squeezePlayer *player);
    void updateProgress();

    void updateActivePlayer(int index);
    void unsubscribePlayer(squeezePlayer* player);

    void requestSqueezeList(const QString command, quint16 count=100, quint16 start=0, quint16 batch=0, QString tags=QString());
    void requestSqueezeList(const QStringList command, quint16 count=100, quint16 start=0, quint16 batch=0, QString tags=QString());
    void playlistItemClicked(QListWidgetItem* song);
    void updateXmlBrowserList(const QString command="", QStringList *parameters=0, QString divider="id",QTreeWidget* parentTreeWidget=0);
    void updateXmlList(const QString listType, QListWidget* listParent, QStringList* itemList, const QString divider, xmlListFlags updateFlag=noUpdate);
    void treeItemClicked(QTreeWidgetItem* treeItem);
    void listItemClicked(QListWidgetItem* listItem);


    void sendPlay();
    void sendPause();
    void sendStop();
    void sendPower();
    void sendSkipBack();
    void sendSkipForward();
    void sendPlaylistIndex(quint16 index);
    void sendPlaylistClear();
    void sendList(QStringList command, quint16 count=0, quint16 start=0, QString tags=STATUSTAGS);

    void setNewProgress(int index);
    void setVolume(int index);
    void slotRepeat();
    void slotShuffle();
    void clearCache();
    void savePlaylist();

    quint16 responseIsList (QStringList *parameters, quint16 *pStartIndex, quint16 *pEndIndex);
    void slaveMasterConnect();
    QString responseHandler(QString responseString, bool force=false);
    void responseListHandler(QList<QByteArray> responseByteArrayList, bool force=false);

    void itemUnselect();
    void splitKeyPair(QString keyPair, QString* keyName, QString* keyVal);
    qint16 getNumberOfPlayers(QString responseString);
    QString getKeyValue(QString responseString, QString keyName, bool* ok=0);
    QString getInitValue(QString responseString, QString keyName);
    QString getFirstKey(QStringList parameters, QString keyName);
    QString findKeyValue(QStringList* stringListPtr, QString* keyNamePtr, bool* ok=0);


    void receiveUdpDatagram();
    void serverDiscovery();
};

#endif // squeezster_H
