#include "optionwidget.h"

#include <QFormLayout>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QStackedLayout>

#include "util.h"
#include "keyboardoptionwidget.h"

OptionWidget::OptionWidget(QWidget *parent) :
    QWidget(parent)
{    
    mKeyboardWidget = new KeyboardOptionWidget;
    mOptionWidget = optionWidget();

    mStackLayout = new QStackedLayout( this );
    mStackLayout->addWidget( mKeyboardWidget );
    mStackLayout->addWidget( mOptionWidget );
    mStackLayout->setCurrentWidget( mOptionWidget );

    connect (mKeyboardWidget,SIGNAL(done()),SLOT(keyboardDone()));
}

QWidget* OptionWidget::optionWidget()
{
    QWidget* optionWidget = new QWidget;

    mComboBox = new QComboBox;
    mComboBox->addItem("Slow");
    mComboBox->addItem("Normal");
    mComboBox->addItem("Fast");
    mComboBox->addItem("Extream");

    mAccelerometerCheckBox = new QCheckBox("Enable Accelerometer");
    mKeyboardBtn = new QPushButton("View/Change keys");
    QPushButton* backButton = new QPushButton("Done");

    setCurrentSpeed();
    mAccelerometerCheckBox->setChecked( Util::useAccelerometer() );

    connect( mAccelerometerCheckBox,SIGNAL(stateChanged(int)),SLOT(accelerometerChanged(int)));
    connect( mComboBox,SIGNAL(currentIndexChanged(QString)),SLOT(speedChanged(QString)));
    connect( backButton,SIGNAL(clicked()),SIGNAL(optionDone()));
    connect( mKeyboardBtn,SIGNAL(clicked()),SLOT(changeKeyboardSetting()));

    QFormLayout *formLayout = new QFormLayout;
    formLayout->addRow(tr("Speed:"), mComboBox);
    formLayout->addRow(tr("Accelerometer:"), mAccelerometerCheckBox);
    formLayout->addRow(tr("Keyboard:"), mKeyboardBtn);    
    formLayout->addRow(tr(""), backButton);

    optionWidget->setLayout(formLayout);

    return optionWidget;
}

void OptionWidget::setCurrentSpeed()
{
    switch( Util::speed() ) {
    case 250:
        mComboBox->setCurrentIndex( 0 );
        break;
    case 150:
        mComboBox->setCurrentIndex( 2 );
        break;
    case 120:
        mComboBox->setCurrentIndex( 4 );
        break;
    case 200:
    default:
        mComboBox->setCurrentIndex( 1 );
        break;
    }
}

void OptionWidget::speedChanged( const QString& aText )
{
    if( aText == "Slow") {
        Util::setSpeed(250);
    } else if( aText == "Normal") {
        Util::setSpeed(200);
    } else if( aText == "Fast") {
        Util::setSpeed(150);
    } else if( aText == "Extream") {
        Util::setSpeed(120);
    }

}

void OptionWidget::accelerometerChanged(int aNewState)
{
    Util::setUseAccelerometer( mAccelerometerCheckBox->isChecked() );
}

void OptionWidget::keyboardDone()
{
    mStackLayout->setCurrentWidget( mOptionWidget );
}

void OptionWidget::changeKeyboardSetting()
{
    mStackLayout->setCurrentWidget( mKeyboardWidget );
}
