#include "menuwidget.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QStackedLayout>
#include <QCoreApplication>

#include "gamewidget.h"
#include "optionwidget.h"
#include "mybutton.h"


MenuWidget::MenuWidget()
{
    mMenuWidget = createMenuUi();
    mOptionWidget = createOptionWidget();
    mGameWidget = createGameWidget();

    mStackLayout = new QStackedLayout(this);
    mStackLayout->addWidget( mMenuWidget);
    mStackLayout->addWidget( mOptionWidget );
    mStackLayout->addWidget( mGameWidget );

    mStackLayout->setCurrentWidget( mMenuWidget );
}

QWidget* MenuWidget::createMenuUi()
{
    QWidget* menuWidget = new QWidget;

    MyButton* instantGameBtn = new MyButton( QPixmap(":/snake.png"), "New Game");
    //QPushButton* newGameBtn = new QPushButton("New Game");
    MyButton* optionBtn = new MyButton(QPixmap(":/option.png"),"Options");
    MyButton* exitButton = new MyButton( QPixmap(":/exit.png"), "Exit");

    QLabel* gameLabel = new QLabel;
    gameLabel->setPixmap( QPixmap(":/snake_text.png"));
    gameLabel->setAlignment( Qt::AlignCenter);

    connect(instantGameBtn,SIGNAL(clicked()),SLOT(instatGame()));
    //connect(newGameBtn,SIGNAL(clicked()),SLOT(newGame()));
    connect(optionBtn,SIGNAL(clicked()),SLOT(option()));
    connect(exitButton,SIGNAL(clicked()),QCoreApplication::instance(),SLOT(quit()));

    QHBoxLayout* btnLayout = new QHBoxLayout;
    btnLayout->addWidget( instantGameBtn);    
    btnLayout->addWidget( optionBtn );
    btnLayout->addWidget( exitButton );

    QVBoxLayout* mainLayout = new QVBoxLayout( menuWidget );
    mainLayout->addStretch();
    mainLayout->addWidget( gameLabel );
    mainLayout->addStretch();
    mainLayout->addLayout( btnLayout );
    mainLayout->addStretch();

    return menuWidget;
}

GameWidget* MenuWidget::createGameWidget()
{
    GameWidget* gameWidget = new GameWidget;
    connect(gameWidget,SIGNAL(showMenu()),SLOT(showMenu()));

    return gameWidget;
}

OptionWidget* MenuWidget::createOptionWidget()
{
    OptionWidget* optionWidget = new OptionWidget;
    connect(optionWidget,SIGNAL(optionDone()),SLOT(showMenu()));

    return optionWidget;
}


void MenuWidget::instatGame()
{
    //set random board
    mStackLayout->setCurrentWidget( mGameWidget );
    mGameWidget->setFocus();
    mGameWidget->newGame();
}

void MenuWidget::newGame()
{
    //set board choosen by user
    mStackLayout->setCurrentWidget( mGameWidget );
    mGameWidget->newGame();
}

void MenuWidget::option()
{
    //show option screen
    mStackLayout->setCurrentWidget( mOptionWidget );
}

void MenuWidget::showMenu()
{
    mStackLayout->setCurrentWidget( mMenuWidget );
}
