#include "keyboardoptionwidget.h"

#include <QFormLayout>
#include <QLineEdit>
#include <QKeyEvent>
#include <QApplication>
#include <QDebug>
#include <QMetaEnum>
#include <QPushButton>

#include "util.h"

KeyboardOptionWidget::KeyboardOptionWidget(QWidget *parent) :
    QWidget(parent)
{
    setupUi();
}

void KeyboardOptionWidget::setupUi()
{
    mUpEdit = new QLineEdit;
    mUpEdit->setReadOnly( true );
    mUpEdit->installEventFilter( this );
    mUpEdit->setText( getKeyString( Util::key("Up")));

    mDownEdit = new QLineEdit;
    mDownEdit->setReadOnly( true );
    mDownEdit->installEventFilter( this );
    mDownEdit->setText( getKeyString( Util::key("Down")));

    mLeftEdit = new QLineEdit;
    mLeftEdit->setReadOnly( true );
    mLeftEdit->installEventFilter( this );
    mLeftEdit->setText( getKeyString( Util::key("Left")));

    mRightEdit = new QLineEdit;
    mRightEdit->setReadOnly( true );
    mRightEdit->installEventFilter( this );
    mRightEdit->setText( getKeyString( Util::key("Right")));

    QPushButton* doneBtn = new QPushButton("Done");
    connect(doneBtn,SIGNAL(clicked()),SIGNAL(done()));

    QFormLayout* mainLayout = new QFormLayout( this );
    mainLayout->addRow( "Up ", mUpEdit);
    mainLayout->addRow( "Down ", mDownEdit);
    mainLayout->addRow( "Left ", mLeftEdit);
    mainLayout->addRow( "Right ", mRightEdit);
    mainLayout->addRow("", doneBtn);
}

bool KeyboardOptionWidget::eventFilter(QObject *object, QEvent *event)
{
    if( event->type() == QEvent::KeyPress ) {
        myKeyPressEvent( static_cast<QKeyEvent *>(event) );
        return true;
    }

    return QObject::eventFilter(object, event);
}

void KeyboardOptionWidget::myKeyPressEvent(QKeyEvent *event)
{
    QWidget* focusWidget = QApplication::focusWidget();
    QLineEdit* focusLineEdit = qobject_cast<QLineEdit*>(focusWidget) ;
    if( focusLineEdit == 0) {
        event->ignore();
       return;
    }

    focusLineEdit->setText( getKeyString(event->key()) );

    if( focusLineEdit == mUpEdit ) {
        Util::setKey("Up", event->key());
    } else if( focusLineEdit == mDownEdit ) {
        Util::setKey("Down", event->key());
    } else if( focusLineEdit == mLeftEdit ) {
        Util::setKey("Left", event->key());
    } else if( focusLineEdit == mRightEdit ) {
        Util::setKey("Right", event->key());
    }

    event->accept();
}

QString KeyboardOptionWidget::getKeyString( int aKeyCode )
{
    int index = QApplication::staticQtMetaObject.indexOfEnumerator("Key");
    QMetaEnum metaEnum = QApplication::staticQtMetaObject.enumerator( index);    
    QString keyString = metaEnum.valueToKey( aKeyCode );
    return keyString.replace("Key_","");
}
