#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <QWidget>
#include <QKeyEvent>
#include <QPen>

class QPaintEvent;
class Snake;
class QTimer;
class Bord;
class MotionSenser;

class GameWidget : public QWidget
{
    Q_OBJECT

public:

    GameWidget();

    ~GameWidget();

    void newGame( int aBordId = -1 );

signals:

    void showMenu();

private:

    void endGame();

    void paintEvent(QPaintEvent *);

    void drawGame( QPainter* aPainter );

    void drawGrid( QPainter* aPainter);

    void drawScore( QPainter* aPainter );

    void drawGameOver( QPainter* aPainter );

    void drawHighlight( QPainter* aPainter );

    void drawPausedScree( QPainter* aPainter );

    void drawOpaqueLayer( QPainter* aPainter );

    void mousePressEvent(QMouseEvent *);

    void keyPressEvent(QKeyEvent *);

private slots:

    void gameLoop();

    void generateMouse();

    void generateBonusMouse();

    QPoint randomMousePos();

    void invalidateBonus();

    void keyEvent( QPoint aDirection  );

    void disableDisplayOff();

private:

    enum GameState {
        NotStarted,
        Started,
        Paused,
        Ended
    };

private:

    Snake* mSnake;
    QPoint mMouse;
    QPoint mBonusMouse;
    QTimer* mTimer;
    QTimer* mBonusTimer;
    Bord* mBord;
    MotionSenser* mSenser;
    int mScore;        
    // counter to prevent display off
    int mDisplayCounter;
    GameState mGameState;

    QPen mGridPen;
};

#endif // GAMEWIDGET_H
