#ifndef BORDS_H
#define BORDS_H

#include "bord.h"

class EmptyBord : public Bord
{
public:
    EmptyBord():Bord()
    {
    }
};

class SimpleBord : public Bord
{
public:
    SimpleBord():Bord()
    {
        mWall << QRect(200,80,400,20);
        mWall << QRect(200,380,400,20);

        mWall << QRect(200,180,20,120);
        mWall << QRect(600,180,20,120);
    }
};

class TwoCBlock: public Bord
{
public:

    TwoCBlock():Bord()
    {
        mWall << QRect(100,80,580,20);
        mWall << QRect(100,80,20,260);
        mWall << QRect(680,80,20,260);

        mWall << QRect(240,380,320,20);
        mWall << QRect(240,200,20,180);
        mWall << QRect(540,200,20,180);
    }
};

class ClosedRect: public Bord
{
public:

    ClosedRect():Bord()
    {
        mWall << QRect(0,0,800,20);
        mWall << QRect(0,460,800,20);

        mWall << QRect(0,0,20,480);
        mWall << QRect(780,0,20,480);
    }
};

class BordFactory
{
public:

    static Bord* createRandomBord()
    {
        int bordId = qrand()%4;
        return createBord( bordId );
    }

    static Bord* createBord( int aBordId )
    {
        switch( aBordId ) {
        case 0: //empty bord
            return new EmptyBord;
        case 1: //simple board
            return new SimpleBord;
        case 2: //two C board
            return new TwoCBlock;
        case 3: //closed rect
        default:
            return new ClosedRect;

        }
    }
};


#endif // BORDS_H
