#include "bord.h"

#include <QPainter>
#include <QPoint>

#include "snake.h"

Bord::Bord()
{
}

Bord::~Bord()
{
}

void Bord::draw( QPainter* aPainter )
{
    foreach( QRect wallRect, mWall ) {
        aPainter->drawRect( wallRect );
        aPainter->fillRect( wallRect, Qt::darkMagenta );
    }
}

bool Bord::isColliding( Snake* aSnake )
{
    return isColliding( aSnake->pos() );
}

bool Bord::isColliding( QPoint aPoint )
{
    foreach( QRect wallRect, mWall ) {
        if( wallRect.contains( aPoint )) {
            return true;
        }
    }

    return false;
}



