# @abstract Send a camera live stream as part of the SMSCON application.
# @version $Id: live-camera.sh 187 2012-05-31 19:59:30Z yablacky $
# @usage Runs on N900 phone device and is started and stopped by SMSCON on behalf of COM_CAMERA command.
# @copyright Lutz Schwarz <schwarz.ware@gmx.de>
# @license GPL V2
# Acts as network client: take video stream and send it to server on particular host on udp port 5000
DEV_VIDEO=/dev/video${1:-1}
LIVE_VIEWER_HOST=${2:-lsx06.fritz.box}
LIVE_VIEWER_PORT=${3:-5000}
LIVE_VIEWER_URI=udp://${LIVE_VIEWER_HOST}:${LIVE_VIEWER_PORT}

VIDEO_DIMENSIONS="width=160,height=120"
if ifconfig|grep wlan>/dev/null
then
	VIDEO_DIMENSIONS="width=320,height=240"
fi

/opt/smscon/camctrl --silent --device "$DEV_VIDEO" -aaa 0&
ALSPID=$!
trap "kill -INT $ALSPID 2>/dev/null" 0
gst-launch \
	v4l2camsrc device="$DEV_VIDEO" !\
	videorate ! video/x-raw-yuv,framerate=15/1,${VIDEO_DIMENSIONS},format='(fourcc)'UYVY !\
	videoscale method=nearest-neighbour !\
	dsph263enc keyframe-interval=10 ! video/x-h263 ! rtph263pay pt=96 !\
	udpsink host=${LIVE_VIEWER_HOST} port=${LIVE_VIEWER_PORT} sync=false&
GSTPID=$!
trap "kill -INT $ALSPID $GSTPID" TERM INT
echo $(date +'%Y-%m-%d %H:%M:%S')[CAMERA] INFO: Started camera $DEV_VIDEO for ${LIVE_VIEWER_URI}.>>/opt/smscon/smscon.log
wait $GSTPID
echo $(date +'%Y-%m-%d %H:%M:%S')[CAMERA] INFO: Stopped camera $DEV_VIDEO for ${LIVE_VIEWER_URI}.>>/opt/smscon/smscon.log
