#!/bin/sh
#
# description: Starts and stops the smbd and nmbd daemons
#
# config:  /etc/samba/smb.conf




RETVAL=0


start()
	{
	KIND="SAMBA"
	echo -n $"Starting $KIND services: "
	smbd
	nmbd
	RETVAL=$?
	echo
	if [ $RETVAL -eq 0 ]; then
	    RETVAL=1
	fi
	return $RETVAL
	}

stop()
	{
	KIND="SAMBA"
	echo -n $"Shutting down $KIND services: "
	killall smbd
	killall nmbd
	RETVAL=$?
	echo
	return $RETVAL
	}

restart()
	{
	stop
	start
	}



case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  restart)
	restart
	;;
  *)
	echo $"Usage: $0 {start|stop|restart}"
	exit 1
esac

exit $?
