#Run it manually:
# cd /usr/lib/hildon-desktop
# python2.5 sleeper.py

import gtk
import pygtk
import hildon
import hildondesktop
import dbus
import os
import time 
import gobject
 
class SleeperHomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.timer = False
    
    #Draw the widget buttons
    self.button15 = gtk.ToggleButton("15")
    self.button15.set_size_request(64,64)
    self.button15.connect("toggled", self.on_toggled, 15)
    self.button15.show_all()

    self.button30 = gtk.ToggleButton("30")
    self.button30.set_size_request(48,48) 
    self.button30.connect("toggled", self.on_toggled, 30)
    self.button30.show_all()
    
    vbox = gtk.VBox(True) 
    vbox.pack_start(self.button15)
    vbox.pack_start(self.button30)
    self.add(vbox) 
    self.set_opacity(0.5)
    vbox.show()
    
  def on_toggled(self, button, data):
    if button.get_active()==False:  #Button got deactivated
      if self.timer != None:
        gobject.source_remove(self.timer)
        banner = hildon.hildon_banner_show_information(self, "", "sleeper: Timer aborted.")
        banner.set_timeout(2000)
        print "sleeper: " + time.strftime("%H:%M:%S") + " - Timer aborted"
      return
    else:  #Button got activated, start this timer
      #Already another timer running? Deactivate set corresponding button as in active
      if self.timer != None:
        if button == self.button15:
          self.button30.set_active(False)
        else:
          self.button15.set_active(False)         
      self.timer = gobject.timeout_add_seconds(data * 60, self.sleeptimer_cb, data, button)      
      banner = hildon.hildon_banner_show_information(self, "", "sleeper: " +str(data)+ " minutes to go, sleep well...")
      banner.set_timeout(2000)
      print "sleeper: " + time.strftime("%H:%M:%S") + " - " +str(data)+ " minutes to go, sleep well..."
  
  def sleeptimer_cb(self,data,button):
    #Stop the music    
    self.Timer = False
    button.set_active(False)
    banner = hildon.hildon_banner_show_information(self, "", "sleeper: " + "Mediaplayer paused after "+str(data)+" minutes, sleep well...")
    banner.set_timeout(2000)
    try:
      bus = dbus.SessionBus()
      gstrenderer = bus.get_object('com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer',
                          '/com/nokia/mafw/renderer/gstrenderer')
      gstrenderer.pause(dbus_interface="com.nokia.mafw.renderer")
      print "sleeper: " + time.strftime("%H:%M:%S") + " - Mediaplayer paused after "+str(data)+" minutes, sleep well..."
    except:
      print "sleeper: " + time.strftime("%H:%M:%S") + " - Mediaplayer already paused..."
    return False
          
hd_plugin_type = SleeperHomePlugin

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

    