#include "timedstate.h"

TimedState::TimedState(const QString& name, int timeout, QState *parent)
    : QState(parent), m_name(name), m_timeout(timeout)
{
}

void TimedState::onEntry(QEvent */*event*/)
{
    qDebug("TimedState[%s]::onEntry", qPrintable(m_name));
    if (!m_timer.isActive())
        m_timer.start(1000, this);
    m_elapsedTimer.restart();
}

void TimedState::onExit(QEvent* /*event*/)
{
    m_timer.stop();
}

void TimedState::timerEvent(QTimerEvent *)
{
    if (m_elapsedTimer.hasExpired(m_timeout))
        emit finished();
}

void TimedState::setTimeout(int timeout)
{
    if (timeout > 0)
        m_timeout = timeout;
}
