// checksum 0x9a77 version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#ifdef Q_WS_MAEMO_5
#include <QSystemScreenSaver>
#include <QtDBus>
#include <QStateMachine>
#include <QState>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include "timedstate.h"
#include <QTimer>

QTM_USE_NAMESPACE
#endif

#include "xbmc.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_PROPERTY(ScreenState screenstate READ getScreenState WRITE setScreenState)
    Q_ENUMS(ScreenState)

public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    enum ScreenState {
        DefaultState,
        CustomState,
        CustomUnlockedState,
        CustomUnlockedNormalState,
        CustomUnlockedDimmedState,
        CustomLockedState,
        DeactivatedState,
        UndefinedScreenState
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

    ScreenState getScreenState() const { return m_screenState; }
    void setScreenState(ScreenState state);

signals:
    void screenLocked();
    void screenUnlocked();
    void deactivated();
    void activated();

private slots:
    void on_actionSetup_triggered();
    void on_actionOpenWebHomepage_triggered();

    void on_rightBtn_clicked();
    void on_leftBtn_clicked();
    void on_upBtn_clicked();
    void on_downBtn_clicked();
    void on_selectButton_clicked();

    void on_playBtn_clicked();
    void on_stopBtn_clicked();

    void on_muteBtn_clicked();
    void on_volumeUpBtn_clicked();
    void on_volumeDownBtn_clicked();

    void on_nextSubtitleBtn_clicked();
    void on_nextLanguageBtn_clicked();

    void on_showGuiBtn_clicked();
    void on_contextMenuBtn_clicked();
    void on_sendEscKeyBtn_clicked();

    void onScreenLockModeChanged(const QString& state);
    void onActiveTimerTimeout();

private:
    void enableCustomScreenSaver(bool enabled);
    void buildStateMachine();
    void setScreenBrightness(int value);

    Ui::MainWindow *m_ui;
    Xbmc* m_xbmc;
    ScreenState m_screenState;

    QTimer* m_activeTimer;
    bool m_prevActivatedState;

#ifdef Q_WS_MAEMO_5
    QSystemScreenSaver* m_screenSaver;
    QDBusConnection m_dbus;
    QDBusInterface *m_dbusMceInterface;
    QDBusInterface *m_dbusHalInterface;
    QStateMachine *m_stateMachine;
    QState* m_defaultState;
    QState* m_customState;
    QState* m_customUnlockedState;
    TimedState* m_customUnlockedNormalState;
    TimedState* m_customUnlockedDimState;
    QState* m_customLockedState;
    QState* m_deactivatedState;
    QHistoryState* m_customHistoryState;
#endif
};

#endif // MAINWINDOW_H
