#!/bin/sh
# postrm script for simplenotewidget
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postrm> `remove'
#        * <postrm> `purge'
#        * <old-postrm> `upgrade' <new-version>
#        * <new-postrm> `failed-upgrade' <old-version>
#        * <new-postrm> `abort-install'
#        * <new-postrm> `abort-install' <old-version>
#        * <new-postrm> `abort-upgrade' <old-version>
#        * <disappearer's-postrm> `disappear' <overwriter>
#          <overwriter-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
	upgrade|failed-upgrade|abort-install|abort-upgrade|disappear)
	;;
	purge|remove)	
	killall -9 simplenotewidget
	test -f /home/user/.config/janbergmann/simplenotewidget.conf && rm -f /home/user/.config/janbergmann/simplenotewidget.conf 
	test -f /usr/bin/simplenotewidget && rm -f /usr/bin/simplenotewidget
	test -f /usr/share/pixmaps/simplenotewidget.png && rm -f /usr/share/pixmaps/simplenotewidget.png
	test -f /usr/share/applications/hildon/simplenotewidget.desktop && rm -f /usr/share/applications/hildon/simplenotewidget.desktop
	test -f /usr/share/applications/hildon-home/simplenotewidget.desktop && rm -f /usr/share/applications/hildon-home/simplenotewidget.desktop
	;;

    *)
        echo "postrm called with unknown argument \`$1'" >&2
        exit 1

esac 


# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

#DEBHELPER#

exit 0


