#include <QtGui/QApplication>
#include "mainwindow.h"


#ifdef Q_WS_HILDON
//Q_WS_MAEMO_5
  #include <QHBoxLayout>
  #include <X11/extensions/Xrender.h>
#endif


int main(int argc, char *argv[])
{
    QCoreApplication::setOrganizationName("Jan Bergmann");
    QCoreApplication::setApplicationName("simplenotewidget");


#ifdef Q_WS_HILDON

    qWarning("Please make sure you're running a composition manager!");
    bool  argbVisual=false;
     Display *dpy = XOpenDisplay(0); // open default display
     if (!dpy) {
         qWarning("Cannot connect to the X server");
         exit(1);
     }


     int screen = DefaultScreen(dpy);
     Colormap colormap = 0;
     Visual *visual = 0;
     int eventBase, errorBase;

     if (XRenderQueryExtension(dpy, &eventBase, &errorBase)) {
         int nvi;
         XVisualInfo templ;
         templ.screen  = screen;
         templ.depth   = 32;
         templ.c_class = TrueColor;
         XVisualInfo *xvi = XGetVisualInfo(dpy, VisualScreenMask |
                                           VisualDepthMask |
                                           VisualClassMask, &templ, &nvi);

         for (int i = 0; i < nvi; ++i) {
             XRenderPictFormat *format = XRenderFindVisualFormat(dpy,
                                                                 xvi[i].visual);
             if (format->type == PictTypeDirect && format->direct.alphaMask) {
                 visual = xvi[i].visual;
                 colormap = XCreateColormap(dpy, RootWindow(dpy, screen),
                                            visual, AllocNone);
                 argbVisual=true;
                 break;
             }
         }
     }
     if (argbVisual == true) {
         qWarning("Found ARGB visual. Starting app...");
     }
     else  {
         qWarning("Couldn't find ARGB visual... Exiting.");
     }

     QApplication app(dpy, argc, argv, Qt::HANDLE(visual), Qt::HANDLE(colormap));

#else
     QApplication app(argc, argv);
#endif


    MainWindow w;
    w.resize(300, 180);
    w.show();
    return app.exec();
}
