#include "dialog.h"
#include "ui_dialog.h"
#include <QFile>
#include <QXmlStreamWriter>
#include <QDateTime>
#include <QDir>

QString GetDataFileDlg()
{
#ifdef Q_WS_HILDON
    QString sPath = QDir::homePath() + QLatin1String("/MyDocs/.simplenotewidget/");
    QString filename =sPath + "simplenotewidget.xml";
    QDir dir;
    dir.mkpath(sPath);
#else
    QString filename = QApplication::applicationDirPath()  + "/simplenotewidget.xml";
#endif
    return   filename;
}






void Dialog::LoadItems()
{
     QString filename = GetDataFileDlg();
     QFile file(filename);
     file.open(QIODevice::ReadOnly );
     QXmlStreamReader Rxml(&file);
     Rxml.setDevice(&file);
     Rxml.readNext();
     while(!Rxml.atEnd())
     {
         if(Rxml.isStartElement())
                 {

                     if(Rxml.name() == "simplenotewidget")
                     {
                           Rxml.readNext();
                     }
                     else if(Rxml.name() == "noteelement")
                     {
                         QXmlStreamAttributes attributes = Rxml.attributes();
                         //QString sNodeText = attributes.value("note").toString();
                         //QString sNodeDate =  attributes.value("notedate").toString();

                         ui->teMain->setText(attributes.value("note").toString());
                         Rxml.readNext();
                     }

                     else
                     {
                       Rxml.raiseError(QObject::tr("Not a simplenotewidget file"));
                         Rxml.readNext();
                     }
                 }
                         else
                         {
                                 Rxml.readNext();
                         }

}
file.close();
}

void Dialog::SaveItems()
{
    QString filename = GetDataFileDlg();
    QFile file(filename);
    file.open(QIODevice::WriteOnly);
    QXmlStreamWriter xmlWriter(&file);
    xmlWriter.setAutoFormatting(true);
    xmlWriter.writeStartDocument();
      xmlWriter.writeStartElement("simplenotewidget");
        xmlWriter.writeStartElement("noteelement");
          xmlWriter.writeAttribute("noteid", "0");
          QDateTime dateTime = QDateTime::currentDateTime();
          QString dateTimeString = dateTime.toString("dd.MM.yyyy   HH:mm");
          xmlWriter.writeAttribute("note",  ui->teMain->toPlainText());
          xmlWriter.writeAttribute("notedate",dateTimeString);
        xmlWriter.writeEndElement();
      xmlWriter.writeEndElement();
    //xmlWriter.writeEndElement();
    xmlWriter.writeEndDocument();
    file.close();
}

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);


    //this->setAutoFillBackground(false);


    //QColor cldefault(250,235,146);
    QColor cldefault(255,255,0);
    QColor cltextedit(0,0,0);

    //this->setPalette(QPalette(cldefault));
    //this->setAutoFillBackground(true);
    this->setWindowTitle("Edit note");

    this->setWindowModality(Qt::ApplicationModal);



    ui->teMain->setFrameShadow(QFrame::Plain);
    ui->teMain->setFrameShape(QFrame::NoFrame);
    ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    ui->teMain->setFontFamily("Nokia Sans SemiBold");
    ui->teMain->setFontPointSize(12);
    ui->teMain->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
    ui->teMain->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    LoadItems();
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Dialog::on_pbOK_clicked()
{

    SaveItems();
    this->close();
}

void Dialog::on_pbCancel_clicked()
{
    this->close();
}
