#include "periodwindow.h"
#include <QHBoxLayout>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QDebug>
#include <QDate>
#include <QMaemo5InformationBox>
#include "datechooserdialog.h"

PeriodWindow::PeriodWindow(int minYear,
                           int minMonth,
                           int maxYear,
                           int maxMonth,
                           QWidget *parent)
        : QWidget (parent)
{
        setAttribute(Qt::WA_Maemo5StackedWindow);
        setAttribute(Qt::WA_DeleteOnClose);
        setWindowFlags(windowFlags() | Qt::Window);

        _minYear = minYear;
        _minMonth = minMonth;
        _maxYear = maxYear;
        _maxMonth = maxMonth;
        _startYear = 0;
        _startMonth = 0;
        _endYear = 0;
        _endMonth = 0;

        vbox = new QVBoxLayout(this);

        QHBoxLayout *hbox = new QHBoxLayout();
        vbox->addLayout(hbox, 0);

        fromLabel = new QLabel(tr("Months from"));
        hbox->addWidget(fromLabel, 0, Qt::AlignCenter);

        startDate = new QMaemo5ValueButton();
        startDate->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        hbox->addWidget(startDate, 1);
        connect (startDate, SIGNAL(clicked()), this, SLOT(startDateClicked()));

        toLabel = new QLabel(tr("to"));
        hbox->addWidget(toLabel, 0, Qt::AlignCenter);

        endDate = new QMaemo5ValueButton();
        endDate->setValueLayout(QMaemo5ValueButton::ValueBesideText);
        hbox->addWidget(endDate, 1);
        connect (endDate, SIGNAL(clicked()), this, SLOT(endDateClicked()));

        loadButton = new QPushButton(tr("Update"));
        connect(loadButton, SIGNAL(clicked()), this, SLOT(loadButtonClicked()));
        hbox->addWidget(loadButton);
}

PeriodWindow::~PeriodWindow()
{
}

void PeriodWindow::loadButtonClicked()
{
        if (_startMonth == 0 || _startYear == 0) {
                QMaemo5InformationBox::information(this, tr("Choose a period start date"));
                return;
        }

        if (_endMonth == 0 || _endYear == 0) {
                QMaemo5InformationBox::information(this, tr("Choose a period finish date"));
                return;
        }

        /* starting date must be lower or equal to end date */
        if (QDate(_startYear, _startMonth, 1) > QDate(_endYear, _endMonth, 1)) {
                QMaemo5InformationBox::information(this, tr("Start date must be prior to end date"));
                return;
        }

        emit periodChanged(_startYear, _startMonth, _endYear, _endMonth);
}

void PeriodWindow::startDateClicked()
{
        int year = _startYear;
        int month = _startMonth;

        if (DateChooserDialog::askDate(_minYear, _minMonth, _maxYear, _maxMonth, year, month)) {
                _startYear = year;
                _startMonth = month;

                startDate->setValueText(QString("%1 %2").arg(QDate::longMonthName(_startMonth)).arg(_startYear));
        }
}

void PeriodWindow::endDateClicked()
{
        int year = _endYear;
        int month = _endMonth;

        if (DateChooserDialog::askDate(_minYear, _minMonth, _maxYear, _maxMonth, year, month)) {
                _endYear = year;
                _endMonth = month;

                endDate->setValueText(QString("%1 %2").arg(QDate::longMonthName(_endMonth)).arg(_endYear));
        }
}
