/*
 * SiBApplication.h
 *
 *  Created on: Nov 2, 2009
 *      Author: oli
 */

#ifndef SIBAPPLICATION_H_
#define SIBAPPLICATION_H_

#include <QtCore/qobject.h>
#include "mainwindow.h"
#include "Settings.h"
#include "filelist.h"

class PlayerFacade;

class SiBApplication : public QObject {
	Q_OBJECT

public:
    static SiBApplication* instance();
    static void release();

private:
	SiBApplication();
	virtual ~SiBApplication();

public:
	void start();

    /**
     * Updates the list model.
     */
    void updateFileList();

    /**
     * Refreshes the list model (only updating screen info/no folder scanning).
     */
    void refreshFileList();

    /**
     * Sorts the list model.
     */
    void sortFileList( FileList::SortCriteria criteria, Qt::SortOrder order );

    void playFile( int idx );

    void restartFile( int idx );

    void stopPlayer();

    bool hasFileResumePos( int idx );

    Settings& settings();

    void handleKeyEvent( QKeyEvent* event );

    bool isPlayerRunning();

private:
    static SiBApplication* m_instance;

    MainWindow* m_mainWindow;
    Settings* m_settings;
    FileList* m_fileList;
    PlayerFacade* m_player;
};

#endif /* SIBAPPLICATION_H_ */
