#include "videofile.h"

VideoFile::VideoFile( QFileInfo file, QObject* parent ) :
    QObject( parent ),
    m_file( file ),
    m_currentPosTenthOfASec( 0 )
{
}

VideoFile::VideoFile( QFileInfo file, unsigned int resumePosTenthOfASec, QObject* parent ) :
    QObject( parent ),
    m_file( file ),
    m_currentPosTenthOfASec( resumePosTenthOfASec )
{
}


QFileInfo VideoFile::file() const
{
    return m_file;
}

void VideoFile::setResumePos( unsigned int tenthOfASec ) {
    m_currentPosTenthOfASec = tenthOfASec;
}

unsigned int VideoFile::resumePos() {
    return m_currentPosTenthOfASec;
}
