#ifndef PLAYERFACADE_H
#define PLAYERFACADE_H

#include <QObject>
#include <QProcess>

class QFileInfo;
class VideoFile;
class QKeyEvent;

class PlayerFacade : public QObject
{
    Q_OBJECT;

public:
    PlayerFacade( QObject* parent );
    ~PlayerFacade();

private slots:
    void playerStarted();
    void playerExited( int exitCode, QProcess::ExitStatus exitStatus );
    void playerHasOutputData();

signals:
    void playerStart();
    void playerStop();

public:
    int playFile( VideoFile* file );
    bool isPlayerRunning();
    void stop();

    /**
     * Forwards a key press to mplayer.
     */
    void forwardKeyEvent( QKeyEvent* event );

private:
    QProcess* m_mplayer;
    VideoFile* m_currentFile; // not owned
    bool m_playerIsRunning;
};

#endif // PLAYERFACADE_H
