/*
 * Settings.cpp
 *
 *  Created on: Nov 2, 2009
 *      Author: oli
 */

#include "Settings.h"
#include <QDir>
#include <QCoreApplication>

Settings::Settings( QObject* parent ) :
    QObject( parent ),
    m_initialized( 0 )
{
    QCoreApplication::setOrganizationName( COMPANY );
    QCoreApplication::setApplicationName( PRODUCTNAME );

    m_settings = new QSettings( this );

    loadSettings();

    if ( !m_initialized ) {
    	m_searchFolders.append( DEFAULT_SEARCHFOLDER );
    }
}

Settings::~Settings()
{
    saveSettings();
}

const QList<QString>& Settings::searchFolders()
{
    return m_searchFolders;
}

void Settings::addFolder( QString folder )
{
    if ( !m_searchFolders.contains( folder ) ) {
        m_searchFolders.append( QDir::toNativeSeparators( folder ) );
    }
    saveSettings();
}

void Settings::removeFolder( QString folder )
{
    m_searchFolders.removeOne( folder );
    saveSettings();
}

void Settings::saveSettings()
{
	m_settings->setValue( KEY_INIT, true );
    m_settings->remove( PREFIX_SEARCHFOLDERS );
    m_settings->beginWriteArray( PREFIX_SEARCHFOLDERS );
    for ( int i = 0; i < m_searchFolders.count(); i++ ) {
        m_settings->setArrayIndex( i );
        m_settings->setValue( KEY_FOLDER, m_searchFolders[i] );
    }
    m_settings->endArray();
}

void Settings::loadSettings()
{
	m_initialized = m_settings->value( KEY_INIT ).toBool();
    int size =  m_settings->beginReadArray( PREFIX_SEARCHFOLDERS );
    for ( int i = 0; i < size; i++ ) {
        m_settings->setArrayIndex( i );
        m_searchFolders.append( m_settings->value( KEY_FOLDER ).toString() );
    }
    m_settings->endArray();
}
