#ifndef __blip_xml_h__
#define __blip_xml_h__

#include <glib.h>
#include "blip_error.h"

G_BEGIN_DECLS

        struct BlipXml_s;
typedef struct BlipXml_s* BlipXml;

enum BlipXmlError_e
{
    BLIP_XML_ERROR_NULL_RESPONSE,
    BLIP_XML_ERROR_OUT_OF_MEMORY,
    BLIP_XML_ERROR_PARSE_FAILED,
    BLIP_XML_ERROR_NO_XPATH_CONTEXT,
    BLIP_XML_ERROR_XPATH_EXPRESSION_NOT_A_TEXT_NODE,
};
typedef enum BlipXmlError_e BlipXmlError;

BlipXml      blip_xml_create(const gchar* xml, BlipError * error);
void         blip_xml_free(BlipXml blipXml);

gchar*       blip_xml_get_text_node_contents(BlipXml blipXml,
                                             gchar * xpathExpr,
                                             BlipError * oError);

/**
 * @brief Query the response from the server for any error.
 * @param [in] blipXml
 *   A valid BlipXml instance created with blip_xml_create().
 * @return
 *   If an error exists in the response, a newly created BlipError will be returned.
 *   Any returned error must be freed with blip_error_free().
 *   If no error ocurred, NULL is returned.
 */
BlipError blip_xml_extract_error(BlipXml blipXml);

G_END_DECLS

#endif // ! __blip_xml_h__
