/*
 * This file is part of sharing-plugin-blipfoto
 *
 * Copyright (C) 2010 Dave Elcock. All rights reserved.
 *
 * This code is licensed under a MIT-style license, that can be
 * found in the file called "COPYING" in the root directory.
 *
 */

#ifndef __BLIP_RESPONSE_H__
#define __BLIP_RESPONSE_H__

#include <glib.h>

G_BEGIN_DECLS

typedef struct BlipResponse_s * BlipResponse;

BlipResponse blip_response_create();
void         blip_response_free(BlipResponse response);

/**
 * @param [in] response
 *   A valid BlipResponse instance created with blip_response_create().
 * @return
 *   Must be freed with g_free()
 */
gchar* blip_response_get_text(BlipResponse response);

size_t blip_response_append(BlipResponse response,
                            const gchar* text,
                            size_t size);

G_END_DECLS

#endif // ! __BLIP_RESPONSE_H__
