#!/usr/bin/env python
"""
 @file: AddComment.py
  File is a part of Scribo Project
  Module implements add comment window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 02.09.2010
"""


from PyQt4 import QtCore
from PyQt4 import QtGui
from ToolbarWindow import ToolbarWindow
from MainWindow import *
from ldm.Profile import *
from ldm.Account import *
from services.LivejAccount import *
from AddPost import AddPostWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/09/02 $"
__copyright__ = ""
__license__ = "GPLv2"

class AddCommentWindow(AddPostWindow):
    """
    class for draw add comment window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent=None, msg=None):
        """ 
        initialization "add comment" window
        @return
        """
        self.parent_msg = msg
        super(AddCommentWindow, self).__init__(parent)

    def create_toolbar_second(self):
        """                                                                                                                                                 
        create second toolbar, without button for adding tags                                                                                              
        @return                                                                                                                                             
        """
        second_tool_bar = ToolbarWindow(parent=self.centr_widg, right=True)
        second_tool_bar.addWidget(self.pict_act)
        second_tool_bar.addWidget(self.other_act)
        #second_tool_bar.addWidget(self.save_act)
        return second_tool_bar

    def create_actions(self):
        """                                                                                                                                                 
        create buttons for toolbar                                                                                                                          
        @return                                                                                                                                             
        """

        self.pict_act = QtGui.QToolButton(self.centr_widg)
        self.pict_act.setIcon(QtGui.QIcon("../data/en/image.png"))
        self.pict_act.setText(self.tr("Add image"))
        self.pict_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.pict_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.pict_act, QtCore.SIGNAL("clicked()"),
                     self.pict_post)

        self.other_act = QtGui.QToolButton(self.centr_widg)
        self.other_act.setIcon(QtGui.QIcon("../data/en/add_html.png"))
        self.other_act.setText(self.tr("HTML"))
        self.other_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.other_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.other_act, QtCore.SIGNAL("clicked()"),
                     self.other_post)
        """
        self.save_act = QtGui.QToolButton(self.centr_widg)
        self.save_act.setIcon(QtGui.QIcon("../data/en/save.png"))
        self.save_act.setText(self.tr("Save"))
        self.save_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.save_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.save_act, QtCore.SIGNAL("clicked()"),
                     self.save_post)
        """
        self.undo_act = QtGui.QToolButton(self.centr_widg)
        self.undo_act.setIcon(QtGui.QIcon("../data/en/undo.png"))
        self.undo_act.setText(self.tr("Undo"))
        self.undo_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.undo_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.undo_act, QtCore.SIGNAL("clicked()"),
                     self.text_edit.undo)

        self.redo_act = QtGui.QToolButton(self.centr_widg)
        self.redo_act.setIcon(QtGui.QIcon("../data/en/redo.png"))
        self.redo_act.setText(self.tr("Redo"))
        self.redo_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.redo_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.redo_act, QtCore.SIGNAL("clicked()"),
                     self.text_edit.redo)

        self.send_act = QtGui.QToolButton(self)
        self.send_act.setIcon(QtGui.QIcon("../data/en/send_post.png"))
        self.send_act.setText(self.tr("Send"))
        self.connect(self.send_act, QtCore.SIGNAL("clicked()"),
                         self.send_comment_ui)
        self.send_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.send_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)



    def send_comment_ui(self):
        """ 
        handler for button OK
        @return
        """
        #if we send post from preview, send current edited post
        #(try except send adding html title)
        if self.combo_view.currentIndex() == 1:
            text_post =self.plain_text
        else:
            text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()

        if (text_post == ""):
            ret = QtGui.QMessageBox.critical(self, self.tr("Scribo"),
                               self.tr("The comment is empty!"),
                               QtGui.QMessageBox.Ok)
            return

        if (self.title_edit.text() == ""):
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Do you want to send commentt"\
                                       " with empty subject?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return
        mes = Message()
        mes.title = unicode(self.title_edit.text())
        mes.text = unicode(text_post)

        send_service = self.parent_msg.poster.service_id
     
        #show dialog with available acoounts from same service
     
        post_dial = QtGui.QMessageBox()
        post_dial.setWindowTitle(self.tr("Scribo"))

        title_label = QtGui.QLabel(self.tr("Choose poster for this comment:"), post_dial)
        post_dial.layout().addWidget(title_label, 0, 0)

        acc_combo = self.create_combo_posters(send_service)
        post_dial.layout().addWidget(acc_combo, 1, 0)
        ok_button = post_dial.addButton(self.tr("OK"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = post_dial.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        post_dial.exec_()
        
        if post_dial.clickedButton() == cancel_button:
            mes.del_msg_tree()
            return
        if post_dial.clickedButton() == ok_button:
            #sending comment from choosing poster
            index = acc_combo.currentIndex()
            poster = self.send_account[index]
            try:
                poster.send_comment(mes, self.parent_msg)
            except WarningExc, exc:
                super(AddCommentWindow, self).show_warning(exc)
                super(AddCommentWindow, self).home_window()
            else:
                ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Comment was send"),
                                                QtGui.QMessageBox.Yes)
                self.sending_post = True

            mes.del_msg_tree()
            self.close()
  

    def create_combo_posters(self, service):
        """                                                                                                                                     
        combo box with all user's accounts
        """
        acc_combo = QtGui.QComboBox()
        self.send_account = []

        for acc in main_prof.accounts:
            if acc.service_id == service:      
                self.send_account.append(acc)
                path_ava = acc.path_to_ava
                if not path_ava:
                    acc_combo.addItem(acc.username)
                else:
                    acc_combo.addItem(QtGui.QIcon(path_ava), acc.username)
   
        return acc_combo

