#!/usr/bin/env python

"""
File is a part of Scribo Project.
Module for providing Exceptioin class for project.
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 5 $"
__date__ = "$Date: 2010/03/19 $"
__copyright__ = ""
__license__ = "GPLv2"

from PyQt4 import QtCore

error_tr = {100 : "Invalid username. Check your user name and try again.",
            101 : "Invalid password. Check your password and try again.",
            102 : "Can't use custom/private security on shared/community journals",
            103 : "Poll error",
            104 : "Error adding one or more friends. Try again or use web interface.",
            105 : "Session expired. Restart application please.",
            150 : "Can't post as non-user. Please login or use web interface.",
            151 : "Banned from journal",
            152 : "Can't make back-dated entries in non-personal journal.",
            153 : "Incorrect time value. Check your time settings.",
            154 : "Can't add a redirected account as a friend",
            155 : "Non-authenticated email address. Please check your email and follow the link.",
            157 : "Tags error. Try to write another tags.",
            200 : "Missing required argument(s).This error may be connected with changing API. \
            Try to repeat attempt later or connect with developers",
            201 : "This operation isn't supported by this blog-service" ,
            202 : "Too many arguments. This error may be connected with changing API. \
            Try to repeat attempt later or connect with developers ",
            203 : "Invalid argument(s). Check your filling data. If this error repeats, try to connect with developers",
            204 : "Invalid metadata datatype. Check your metadata. If this error repeats, try to connect with developers",
            205 : "Unknown metadata. Check your metadata. If this error repeats, try to connect with developers",
            206 : "You can't edit this journal",
            207 : "Protocol version mismatch. This error may be connected with changing API. \
            Try to repeat attempt later or connect with developers ",
            208 : "Invalid text encoding. Please change your locale to english language.",
            209 : "Parameter out of range. Please change parameter value. ",
            210 : "Client tried to edit with corrupt data. Preventing.",
            211 : "Invalid or malformed tag list. Check your tag list. ",
            212 : "Message body is too long. Please cut your message. ",
            213 : "Message body is empty. Write your message.",
            214 : "Message looks like spam. Check your message. ",
            301 : "Access of restricted feature",
            302 : "Can't edit post from requested journal",
            303 : "Can't edit post in community journal",
            304 : "Can't delete post in this community journal",
            305 : "Action forbidden; account is temporary unavailable",
            306 : "This journal is temporarily in read-only mode. Try again in a couple minutes.",
            307 : "Selected journal no longer exists. Try to refresh posts.",
            308 : "Account is locked and cannot be used.",
            309 : "Account is marked as a memorial.",
            310 : "Account needs to be age verified before use. Please check your email and follow the link.",
            311 : "Access temporarily disabled. Please try later. ",
            312 : "Not allowed to add tags to entries in this journal. Delete tags from post.",
            313 : "Must use existing tags for entries in this journal (can't create new ones)",
            314 : "Only paid users allowed to use this request ",
            315 : "User messaging is currently disabled. Try later."
            }

class WarningExc(Exception):
    """
    not critical error (application can work)
    """

    def __init__(self, module, descr, adv=None):
        """
        init new exception
        @param (string) module : place where exception happence
        @param (string) descr : short description of exception
        @param (string) adv : advanced info about error. (default - None)
        """
        super(WarningExc, self).__init__()
        self.module = module.decode('utf-8')
        self.descr = descr.decode('utf-8')
        if adv:
            self.adv = adv.decode('utf-8')
        else:
            self.adv = None



    def __str__(self):
        """
        generate string representation of error
        @return : string with error description
        """
        return str(self.descr) + " in " + str(self.module) + ":\t " + \
               str(self.adv)

    def to_html(self):
        """
        generate HTML contened error description.
        @return : string with error's representation in HTML
        """
        html = "<b>%s</b><br>%s" % (self.descr, self.module)
        if self.adv:
            html += '<br><pre>' + self.adv + '</pre>'
        return html


class XmlrpcExc(WarningExc):
    def __init__(self, acc, exc):
        self.faultCode = exc.faultCode
        self.faultString = exc.faultString
        #from PyQt4 import QtCore
        if error_tr.has_key(self.faultCode):
            self.faultString = str(QtCore.QCoreApplication.translate("WarningExc",error_tr[self.faultCode]).toUtf8())
        account_str =str(QtCore.QCoreApplication.translate("WarningExc","Protocol error in ").toUtf8() + acc.username + '@' + acc.get_name())
        super(XmlrpcExc, self).__init__(account_str, self.faultString)


class SocketExc(WarningExc):
    def __init__(self, acc, exc):
        account_str = 'Networking error in ' + acc.username + '@' + \
                      acc.get_name()

        super(SocketExc, self).__init__(account_str, str(exc))
