#!/usr/bin/env python

"""
===============================================================
    This file conyains main fuction
===============================================================
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 8 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"

import sys
import os
# import python dbus module
#import dbus
# import python dbus GLib mainloop support
#import dbus.mainloop.glib
#import dbus.service


def main():
    """
    this function starts application
    """
    try:

        # Enable glib main loop support
        #dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
        # Get the session bus
        #bus = dbus.SessionBus()

        from PyQt4 import QtGui
        app = QtGui.QApplication(sys.argv) # Note: we can't draw dialog box in 
                                         #       BugReporter before gui init


        # check for another instance of application
        from ScriboExc import WarningExc
        try:
            from ldm.SqlDriver import sql_driver
        except WarningExc, exc:
            QtGui.QMessageBox.warning(None,
                                      "Scribo",
                                      exc.to_html(),
                                      QtGui.QMessageBox.Ok)
            sys.exit()
        import locale, os
        try:
            mylocale = locale.getdefaultlocale()[0]
        except ValueError:
            mylocale = None
        if mylocale == None:
            pass
        else:
           if os.path.isfile("scribo_" + mylocale + ".qm"):
                from PyQt4 import QtCore
                translator = QtCore.QTranslator()
                translator.load("scribo_" + mylocale + ".qm")
                app.installTranslator(translator)

        from ui.HomePage import HomePage
        from ldm.Profile import main_prof
        home_window = HomePage(main_prof.def_account)
        from ConfigDriver import config

        app.exec_()

        sql_driver.close()

        sys.exit()

    except Exception, exc: #IGNORE:W0703
        print "Error..."
        from BugReporter import BugReporter
        from About import __version__ as ver
        BugReporter(exc, ver)


if __name__ == "__main__":
    os.chdir(os.path.dirname(os.path.abspath(sys.argv[0])))
    main()
