#!/usr/bin/env python

"""
===============================================================
Class with test method for SqlDriver module
===============================================================
"""

import sys
sys.path.append("..")
sys.path.append("../ldm")

from SqlDriver import sql_driver
import unittest


__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/06 $"
__copyright__ = ""
__license__ = "GPLv2"


class SqlDriverTest(unittest.TestCase):
    """
    Class with test method for SqlDriver module
    """

    def setUp(self):
        """
        Init variables for test methods
        """

        #global sql_driver
        #sql_driver.close()

        self.driver = sql_driver


    def test_select(self):
        """
        this method tests SqlDriver.select_cmd(cmd, args=None) and
        SqlDriver.select_mcmd(cmd, args=None)
        """
        cmds = [
                'SELECT * FROM Profiles;',
                'SELECT * FROM Messages;',
                'SELECT * FROM Accounts;',
                'SELECT * FROM Profiles WHERE id=1;'
               ]
        for i in cmds:
            self.assertTrue(self.driver.select_cmd(i))
            self.assertTrue(self.driver.select_mcmd(i))


    def test_commit(self):
        """
        this method tests SqlDriver.commit_cmd(cmd, args=None)
        """
        cmds = [
                "CREATE TABLE Profiles2 (id INTEGER, first TEXT);",
                "INSERT INTO Profiles2 (id) VALUES (1);",
                "DROP TABLE Profiles2"
                ]
        for i in cmds:
            self.assertFalse(self.driver.commit_cmd(i))

    '''    
    def test_close(self):
        """
        this method tests SqlDriver.close
        """
        self.driver.close()
        self.driver.close()
        self.driver.close()


    def tearDown(self):
        global sql_driver
        sql_driver = SqlDriver()
        pass
    '''


if __name__ == '__main__':
    unittest.main()
