#!/usr/bin/env python

"""
===============================================================
    This file contains functions to work with Blurty (clone of LiveJournal.com)
    http://www.blurty.com/
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 2 $"
__date__ = "$Date: 2010/02/25 $"
__copyright__ = ""
__license__ = "GPLv2"

import os
import time
import urllib

from LivejAccount import LivejAccount

BLURTY_SERVER = "http://www.blurty.com/interface/xmlrpc:80"
BLURTY_USERPICS = 'http://www.blurty.com/userpic/'


class BlurtyAccount(LivejAccount):

    def __init__(self, id=None):
        super(BlurtyAccount, self).__init__(id, BLURTY_SERVER, BLURTY_USERPICS)


    @staticmethod
    def get_name():
        """
        Get name of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) name of this service
        """

        return 'Blurty'


    @staticmethod
    def get_icon():
        """
        Get path to icon of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) path to icon of this service
        """

        return '../data/blurty.png'


    def send_post(self, msg):
        """
        Send post to Blurty.
        There is no tags in blurty
        
        @return None
        """

        moment = time.localtime()

        param = {}
        param.update({
                      'event': msg.text.replace('\n', '<br />\n'),
                      'subject': msg.title,
                      'security': 'public',
                      'allowmask': '1',
                      'year': moment[0],
                      'mon': moment[1],
                      'day': moment[2],
                      'hour': moment[3],
                      'min': moment[4],
                      'lineendings': '0x0A'
                     })

        if msg.journal and not msg.journal == msg.poster :
            param['usejournal'] = msg.journal.username

        return self.exec_xmlrpc('postevent', param)


    def edit_post(self, msg):
        """
        Edit existing post on Blurty
        There is no tags in blurty
        
        @return None
        """

        moment = time.strptime(msg.date, LJ_TIME_FORMAT)

        param = {}
        param.update({
                      'itemid': msg.custom_id,
                      'event': msg.text,
                      'subject': msg.title,
                      'security': 'public',
                      'allowmask': '1',
                      'year': moment[0],
                      'mon': moment[1],
                      'day': moment[2],
                      'hour': moment[3],
                      'min': moment[4],
                      'lineendings': 'unix'
                     })
        self.exec_xmlrpc('editevent', param)
        # TODO: return result
        return None
