#!/usr/bin/env python
"""
 @file: FriendPosts.py
  File is a part of Scribo Project
  Module implements viewing list of post from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 25.03.2010
"""
import sys
sys.path.append("./src/services")
sys.path.append("./src/ldm")

from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/03/25 $"
__copyright__ = ""
__license__ = "GPLv2"

class FriendPosts(ListMyPosts):
    """
    class for draw list of posts window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent=None):
        """ 
        initialization "list of posts" window
        @return
        """
        super(FriendPosts, self).__init__()

    def get_user_posts(self):
        return main_prof.get_posts()


    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = QtGui.QToolBar("", self)
        file_tool_bar.setIconSize(QtCore.QSize(64, 64))
        file_tool_bar.addAction(self.back_act)
        file_tool_bar.addAction(self.home_act)
        file_tool_bar.addAction(self.refresh_act)
        return file_tool_bar

    def reload_window(self):
        """
        refresh list of posts 
        @param          
        @return
        """
        list_acc = main_prof.accounts
        self.progress = QtGui.QProgressDialog("Operation in progress.", "Cancel", 0, 10, self)
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.value_progress = 1
        self.progress.setValue(self.value_progress)

        self.progress.forceShow()
        for acc in list_acc:
            try:
                acc.refresh_posts(self.callback)
            except WarningExc, exc:
                main_window.show_warning(exc)
            #acc.get_posts(self.callback)
        self.progress.setValue(self.progress.maximum())
        self.vbox.removeWidget(self.mes_list)
        self.mes_list.deleteLater()
        self.mes_list = self.list_posts()
        self.vbox.addWidget(self.mes_list)

    def callback(self):
        self.progress.setValue(self.value_progress)
        self.value_progress = self.value_progress + 1
        print "!!!"


from ViewMessage import *
from Profile import *
