/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _CONVERSATIONS_SEARCH_SETTINGS_
#define _CONVERSATIONS_SEARCH_SETTINGS_
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>	

struct _conversations_search_settings_t
{
  gboolean search_sms;
  gboolean search_im;
  gint search_type;
  time_t start_time;
  time_t end_time;
};

typedef _conversations_search_settings_t conversations_search_settings_t;

void
show_conversations_search_settings_dlg(GtkButton* button, gpointer user_data);

void
conversations_search_settings_read(GConfClient* client, conversations_search_settings_t* conversations_search_settings);

#endif
