#ifndef CARD_H
#define CARD_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <string>

class Card
{
public:
  enum Color {
    spade   = 1,
    cope    = 2,
    bastone = 3,
    denare  = 4
  };

  static const Card minCard;
  static const Card maxCard;

private:
  Color  color;
  size_t value;

public:
  Card(Color color, size_t value);

  bool operator<(const Card& card) const;
  bool operator<=(const Card& card) const;
  bool operator>(const Card& card) const;
  bool operator>=(const Card& card) const;
  bool operator==(const Card& card) const;
  bool operator!=(const Card& card) const;

  Card& operator++();

  std::wstring GetFilename() const;
  std::wstring GetColorName() const;
  std::wstring GetValueName() const;
  size_t GetIndex() const;
  std::wstring GetName() const;

  Color GetColor() const;
  size_t GetValue() const;
  size_t GetPoints() const;
};

#endif

