/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	Save Scummer Development
 *
 * NAME:        avatar.cpp ( 7DRL Library, C++ )
 *
 * COMMENTS:
 */

#include "avatar.h"
#include "item.h"
#include "mob.h"

int glb_avatar_mp = 35;

double glb_avatar_prob = 1.0;
int glb_avatar_probexp = 0;

RACE_NAMES glb_avatar_race = RACE_HUMAN;
ROLE_NAMES glb_avatar_role = ROLE_BARBARIAN;

bool 	   glb_avatar_victory = false;

int	   glb_avatar_playbackdelay = 0;


int
avatar_playbackdelay()
{
    return glb_avatar_playbackdelay;
}

void
avatar_setplaybackdelay(int delay)
{
    glb_avatar_playbackdelay = delay;

    if (delay < 0)
	delay = -1;
}

RACE_NAMES
avatar_race()
{
    return glb_avatar_race;
}

void
avatar_setrace(RACE_NAMES race)
{
    glb_avatar_race = race;
}

ROLE_NAMES
avatar_role()
{
    return glb_avatar_role;
}

void
avatar_setrole(ROLE_NAMES role)
{
    glb_avatar_role = role;
}

double
avatar_weightweapon(ITEM *weapon)
{
    if (weapon->getDefinition() != ITEM_WEAPON)
	return 0.0;

    int		ip, ia, ic;
    double	weight;
    
    weapon->getWeaponStats(ip, ia, ic);

    // These are conveniently normalized.
    weight = ip * glb_roledefs[avatar_role()].w_power;
    weight += ia * glb_roledefs[avatar_role()].w_accuracy;
    weight += ic * glb_roledefs[avatar_role()].w_consistency;
    
    return weight;
}

double
avatar_weightbook(ITEM *book)
{
    if (book->getDefinition() != ITEM_SPELLBOOK)
	return 0.0;

    int		ir, ip, ia, ic, im;
    double	weight;
    
    book->getRangeStats(ir, ip, ic, ia, im);

    // These are not well normalized;
    // We want things in a 0..20 range, so we double
    // the weight of range, 20-5xmana, and 7*area
    weight = ir * glb_roledefs[avatar_role()].b_range * 2;
    weight += ip * glb_roledefs[avatar_role()].b_power;
    weight += ic * glb_roledefs[avatar_role()].b_consistency;
    weight += ia * glb_roledefs[avatar_role()].b_area * 7;
    weight += 20 - im * glb_roledefs[avatar_role()].b_area * 5;
    
    return weight;
}

int
avatar_mp()
{
    return glb_avatar_mp;
}

void
avatar_setmp(int mp)
{
    glb_avatar_mp = mp;
}

int
avatar_maxmp()
{
    return glb_racedefs[avatar_race()].mp +
	    glb_roledefs[avatar_role()].mp;
}

void
avatar_setmaxmp(int mp)
{
}

int
avatar_maxhp()
{
    return glb_racedefs[avatar_race()].hp +
	    glb_roledefs[avatar_role()].hp;
}

void
avatar_setmaxhp(int hp)
{
}


void
avatar_setprob(double prob, int exp)
{
    glb_avatar_prob = prob;
    glb_avatar_probexp = exp;
}

void
avatar_multprob(double mult)
{
    glb_avatar_prob *= mult;

    while (glb_avatar_prob && glb_avatar_prob < 1.0)
    {
	glb_avatar_prob *= 10;
	glb_avatar_probexp--;
    }
}

double
avatar_prob()
{
    return glb_avatar_prob;
}

int
avatar_probexp()
{
    return glb_avatar_probexp;
}

void
avatar_save(ostream &os)
{
    os.write((const char *) &glb_avatar_mp, sizeof(int));
    os.write((const char *) &glb_avatar_prob, sizeof(double));
    os.write((const char *) &glb_avatar_probexp, sizeof(int));
    os.write((const char *) &glb_avatar_race, sizeof(RACE_NAMES));
    os.write((const char *) &glb_avatar_role, sizeof(ROLE_NAMES));
    os.write((const char *) &glb_avatar_playbackdelay, sizeof(int));

    MOB::getAvatarHP_DPDF().save(os);
}

void
avatar_load(istream &is)
{
    is.read((char *) &glb_avatar_mp, sizeof(int));
    is.read((char *) &glb_avatar_prob, sizeof(double));
    is.read((char *) &glb_avatar_probexp, sizeof(int));
    is.read((char *) &glb_avatar_race, sizeof(RACE_NAMES));
    is.read((char *) &glb_avatar_role, sizeof(ROLE_NAMES));
    is.read((char *) &glb_avatar_playbackdelay, sizeof(int));

    MOB::getAvatarHP_DPDF().load(is);
}

bool
avatar_victory()
{
    return glb_avatar_victory;
}

void
avatar_setvictory(bool state)
{
    glb_avatar_victory = state;
}
