#include <QtGui>

#include "rssbar.h"

static const QSize buttonSize(23, 23);
static const QString defaultSite("http://labs.trolltech.com/blogs/feed");

RSSBar::RSSBar(QWidget *parent) : QWidget(parent)
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf-8"));

    /* set default site as current */
    currentSite = defaultSite;

    createActions();
    createMenuButton();
    createDefaultButton();
    createLayout();
    setAppearance();
}

/* creating actions for menu */
void RSSBar::createActions()
{
    quitAction = new QAction(tr("&Выход"), this);
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

    changeFeed = new QAction(tr("&Сменить канал"), this);
    connect(changeFeed, SIGNAL(triggered()), this, SLOT(ChangeFeed()));
}

/* geometry settings for the widget: size and location; other settings*/
void RSSBar::setAppearance()
{
    setGeometry(0,QApplication::desktop()->height()-25-30,QApplication::desktop()->width(),25);
    setMaximumSize(QApplication::desktop()->width(),25);
    setWindowTitle(tr("RSS-Mobile"));

    /* making wigget frameless and with no background */
    setWindowFlags(Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute (Qt::WA_NoSystemBackground);
}

/* creating two general buttons: main menu */
void RSSBar::createMenuButton()
{
    menuButton = new QPushButton();
    menuButton->setIconSize(buttonSize);
    menuButton->setFlat(true);
    menuButton->setIcon(QPixmap::fromImage(QImage("img/rssbutton.png")));
    menuButton->setFixedSize(buttonSize);
    menuButton->setStyleSheet("border-radius: 2px;");
    createMenu();    
}

/* creating two general buttons: changing feed to default */
void RSSBar::createDefaultButton()
{
    defButton = new QPushButton();
    defButton->setIconSize(buttonSize);
    defButton->setIcon(QPixmap::fromImage(QImage("img/qtlogo.png")));
    defButton->setFixedSize(buttonSize);
    defButton->setStyleSheet("border-radius: 2px;");
    connect(defButton,SIGNAL(pressed()),this, SLOT(ToDefault()));
}

/* setting main menu from actions */
void RSSBar::createMenu()
{
    menu = new QMenu();    
    menu->addAction(changeFeed);
    menu->addAction(quitAction);
    menuButton->setMenu(menu);
}

/* main layout */
void RSSBar::createLayout()
{
    QHBoxLayout *mainLayout = new QHBoxLayout;
    mainLayout->setDirection(QBoxLayout::RightToLeft);
    mainLayout->setAlignment(Qt::AlignRight);
    mainLayout->addWidget(menuButton);
    mainLayout->addWidget(defButton);
    mainLayout->setMargin(1);
    mainLayout->setSpacing(2);

    myFeed = new RSSFeed(defaultSite,this);
    mainLayout->addWidget(myFeed);

    setLayout(mainLayout);
}

/* translucent black background */
void RSSBar::paintEvent(QPaintEvent *)
{
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing);
    painter.setPen(Qt::NoPen);
    painter.setBrush(QColor(0, 0, 0, 200));
    painter.drawRect(0, 0, width(), height());
}

/* change current feed from input  dialog */
void RSSBar::ChangeFeed()
{
    bool ok;
    QString newSite = QInputDialog::getText(this, tr("RSS-канал"),
                                             tr("Введите адрес (url):"), QLineEdit::Normal,
                                             currentSite, &ok);
    if (ok && !newSite.isEmpty())
    {
        currentSite = newSite;
        myFeed->fetch(currentSite);
    }
}

/* return to default feed*/
void RSSBar::ToDefault()
{
    currentSite = defaultSite;
    myFeed->fetch(currentSite);
}

/* disable or enable buttons in loading time */
void RSSBar::DisableFetch()
{
    defButton->setDisabled(true);
    changeFeed->setDisabled(true);

}

void RSSBar::EnableFetch()
{
    defButton->setEnabled(true);
    changeFeed->setEnabled(true);
}


