import gtk
import cairo

class Screen(gtk.DrawingArea):
    
    def __init__(self):
        gtk.DrawingArea.__init__(self)
        self.distance = "100"

    # Draw in response to an expose-event
    __gsignals__ = { "expose-event": "override" }

    # Handle the expose-event by drawing
    def do_expose_event(self, event):
        # Create the cairo context
        cr = self.window.cairo_create()

        # Restrict Cairo to the exposed area; avoid extra work
        cr.set_source_rgb(1, 0, 0)
        cr.rectangle(event.area.x, event.area.y,
                800, 480)
        cr.fill()

        self.draw(cr)


    def draw(self, cr):
        cr.set_source_rgb(1, 1, 1)
        cr.set_font_size( 370)
        cr.select_font_face( "Arial")
        if len(self.distance) == 4:
            cr.set_font_size( 350)
            cr.move_to( 10,360)
        elif len(self.distance) == 3:
            cr.move_to( 80,360)
        elif len(self.distance) == 2:
            cr.move_to( 170,360)
        elif len(self.distance) == 1:
            cr.move_to( 260,360)
        else:
            cr.move_to( 10,360)
        cr.text_path( self.distance)                                                                                                                                
        cr.fill()


