/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <ringtoned/plugin.h>
#include "contact.h"


DEFINE_RINGTONED_PLUGIN("per-contact-ringtones", init)

static gboolean
call_filter_cb (RingtonedDispatcher *dispatcher,
                RingtonedCall       *call,
                gpointer             user_data)
{
    GList *contacts;
    GList *l;
    OssoABookContact *contact;
    const gchar *ringtone;

    g_object_get (call, "contacts", &contacts, NULL);
    for (l = contacts; l; l = l->next)
    {
        contact = l->data;
        ringtone = pcr_contact_get_custom_ringtone (contact);
        if (ringtone != PCR_RINGTONE_DEFAULT)
        {
            DEBUG ("Set ringtone for %s to %s",
                    osso_abook_contact_get_display_name (contact),
                    ringtone);
            g_object_set (call, "ringtone-path", ringtone, NULL);
            break;
        }
    }

    return FALSE;
}

void
init (RingtonedDispatcher *dispatcher)
{
    ringtoned_dispatcher_add_filter (dispatcher,
            RINGTONED_FILTER_PRIORITY_DEFAULT, call_filter_cb, NULL, NULL);
}
