/*************************************************************************}
{ timerwindow.h - dialog with a timer settings                            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 May 2012                                              }
{*************************************************************************/

#ifndef TIMERWINDOW_H
#define TIMERWINDOW_H

#include "includes.h"
#include "commondialog.h"
#include "spinnumber.h"

class TimerWindow : public CommonDialog
{
    Q_OBJECT

public:
    explicit TimerWindow(QWidget *parent = 0);
    ~TimerWindow();
    static int showTimerDialog(int mins);
    static void minsToDigits(int mins, int* digits);

protected:
    void initGui();
    void deinitGui();
    void reposition(const QSize &sz);

    SpinNumber
        *spinHrs, *spinHrsTens,
        *spinMins, *spinMinsTens;

    Label *labelHrs, *labelMins;
    Label* labelSep;
    QPushButton* btnStart;

protected slots:
    void onStartClick();
};

#endif // TIMERWINDOW_H
