###########################################################################
# rhapsodie.pro - main project file                                       #
#                                                                         #
# This file is a part of the project                                      #
#   Rhapsodie - Music player for N900                                     #
#                                                                         #
# (c) Alkatraz Studio, 2012                                               #
#                                                                         #
# author: Parfenov Alexey a.k.a. ZXED                                     #
# author's e-mail: zxed@alkatrazstudio.net                                #
# official project site: http://rhapsodie.garage.maemo.org/               #
#                                                                         #
# This program is free software; you can redistribute it and/or           #
# modify it under the terms of the GNU General Public License             #
# as published by the Free Software Foundation; either version 3 of       #
# the License, or (at your option) any later version.                     #
#                                                                         #
# This program is distributed in the hope that it will be useful,         #
# but WITHOUT ANY WARRANTY; without even the implied warranty of          #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        #
# General Public License for more details.                                #
#                                                                         #
# You may read GNU General Public License at:                             #
#   http://www.gnu.org/copyleft/gpl.html                                  #
#                                                                         #
# project started: 09 Feb 2012                                            #
# project version: 1.0                                                    #
# project last modified: 05 Dec 2012                                      #
###########################################################################

TARGET=rhapsodie
QT += phonon dbus

INCLUDEPATH = ./src/
VPATH = ./src/
OBJECTS_DIR = ./obj/
MOC_DIR = ./moc/
UI_DIR = ./ui/
RCC_DIR = ./rcc/

SOURCES += \
    main.cpp \
    mainwindow.cpp \
    phononplayer.cpp \
    phononsound.cpp \
    kineticlistitem.cpp \
    app.cpp \
    typeswindow.cpp \
    optionswindow.cpp \
    optionitem.cpp \
    selectwindow.cpp \
    containerdialog.cpp \
    equalizer.cpp \
    commondialog.cpp \
    equalizerwindow.cpp \
    searchwindow.cpp \
    button.cpp \
    aboutwindow.cpp \
    skin.cpp \
    timerwindow.cpp \
    spinnumber.cpp \
    ../inc/alkatraz.cpp \
    ../inc/qiodevicehelper.cpp \
    ../inc/fsman.cpp \
    ../inc/controls/qkineticwidget.cpp \
    ../inc/qwidgethelper.cpp \
    ../inc/stringhash.cpp \
    ../inc/coreapp.cpp

HEADERS += \
    mainwindow.h \
    phononplayer.h \
    phononsound.h \
    kineticlistitem.h \
    app.h \
    includes.h \
    typeswindow.h \
    skin.h \
    optionswindow.h \
    optionitem.h \
    selectwindow.h \
    containerdialog.h \
    equalizer.h \
    commondialog.h \
    equalizerwindow.h \
    searchwindow.h \
    button.h \
    aboutwindow.h \
    timerwindow.h \
    spinnumber.h \
    ../inc/alkatraz.h \
    ../inc/qiodevicehelper.h \
    ../inc/fsman.h \
    ../inc/controls/qkineticwidget.h \
    ../inc/qwidgethelper.h \
    ../inc/stringhash.h \
    ../inc/coreapp.h

include(deployment.pri)
qtcAddDeployment()

TRANSLATIONS = \
    translations/rhapsodie_ru.ts

QMAKE_CXXFLAGS_RELEASE -= -O1
QMAKE_CXXFLAGS_RELEASE -= -O2
QMAKE_CXXFLAGS_RELEASE += -O3
QMAKE_CXXFLAGS_RELEASE -= -g
QMAKE_CXXFLAGS_RELEASE += -fomit-frame-pointer
QMAKE_CXXFLAGS_RELEASE -= -fno-omit-frame-pointer
QMAKE_CXXFLAGS_RELEASE -= -fno-optimize-sibling-calls

maemo5 {
    DEFINES += MAEMO5

    DESTDIR = ./bin/

    i_tr.path = /opt/rhapsodie/translations
    i_tr.files = translations/rhapsodie_ru.qm
    INSTALLS += i_tr
    i_skins.path = /opt/rhapsodie
    i_skins.files = skins
    INSTALLS += i_skins
    i_data.path = /opt/rhapsodie
    i_data.files = data
    INSTALLS += i_data
    i_html.path = /opt/rhapsodie
    i_html.files = html
    INSTALLS += i_html
}

VERSION=1.0

DEFINES += \
    APP_VERSION=\\\"$$VERSION\\\" \
    APP_NAME=\\\"$$TARGET\\\" \
    APP_STATUS=\\\"stable\\\" \
    APP_TITLE=\"\\\"Rhapsodie\\\"\" \
    APP_ORGANIZATION=\"\\\"Alkatraz\\x20Studio\\\"\" \
    APP_ORGANIZATION_DOMAIN=\\\"alkatrazstudio.net\\\"
