/*************************************************************************}
{ stringhash.cpp - class for string replacements by hash                  }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 28 Jun 2011                                              }
{*************************************************************************/

#include "stringhash.h"

QString StringHash::replaceInString(const QString& string)
{
    QString result = "";
    QChar c;
    QString key;
    QChar sep = '%';
    bool matched;

    int p = 0;
    int n = string.size();
    while(p < n)
    {
        c = string.at(p);
        if(c != sep)
        {
            result += c;
            p++;
        }
        else
        {
            key = "";
            p++;
            matched = false;
            while(p < n)
            {
                c = string.at(p);
                p++;
                if(c == sep)
                {
                    if(key == "")
                    {
                        result += "%";
                        matched = true;
                    }
                    else
                    {
                        if(this->contains(key))
                        {
                            result += this->value(key);
                            matched = true;
                        }
                        else
                        {
                            key += "%";
                        }
                    }
                    break;
                }
                else
                {
                    key += c;
                }
            }
            if(!matched)
                result += "%" + key;
        }
    }

    return result;
}
