/*************************************************************************}
{ qiodevicehelper.h - shortcut functions for QIODevice children           }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 26 Jun 2011                                              }
{*************************************************************************/

#include "qiodevicehelper.h"

bool QIODeviceHelper::writeStringUTF8(const QString& string, char stopChar)
{
    if(((QIODevice*)this)->write(string.toUtf8()) == -1)
        return false;
    return ((QIODevice*)this)->putChar(stopChar);
}

bool QIODeviceHelper::writeStringASCII(const QString& string, char stopChar)
{
    if(((QIODevice*)this)->write(string.toAscii()) == -1)
        return false;
    return ((QIODevice*)this)->putChar(stopChar);
}

QByteArray QIODeviceHelper::readUntilChar(char stopChar)
{
    QByteArray buf;
    char c;
    while(((QIODevice*)this)->getChar(&c))
    {
        if(c==stopChar)
            break;
        buf.append(c);
    }
    return buf;
}

QByteArray QIODeviceHelper::readUntilReturn()
{
    QByteArray buf;
    char c;
    while(((QIODevice*)this)->getChar(&c))
    {
        if(c=='\n')
        {
            ((QIODevice*)this)->peek(&c, 1);
            if(c=='\r')
                ((QIODevice*)this)->getChar(&c);
            break;
        }
        else
            if(c=='\r')
            {
                ((QIODevice*)this)->peek(&c, 1);
                if(c=='\n')
                    ((QIODevice*)this)->getChar(&c);
                break;
            }
        buf.append(c);
    }
    return buf;
}

QString QIODeviceHelper::readStringUTF8(char stopChar)
{
    QByteArray utf = readUntilChar(stopChar);
    return QString::fromUtf8(utf.constData());
}

QString QIODeviceHelper::readStringASCII(char stopChar)
{
    QByteArray ascii = readUntilChar(stopChar);
    return  QString::fromAscii(ascii.constData());
}

QString QIODeviceHelper::readLineUTF8()
{
    QByteArray utf = readUntilReturn();
    return QString::fromUtf8(utf.constData());
}

QString QIODeviceHelper::readLineASCII()
{
    QByteArray ascii = readUntilReturn();
    return QString::fromAscii(ascii.constData());
}

bool QIODeviceHelper::readLn(QByteArray& data)
{
    data = ((QIODevice*)this)->readLine();
    char c;
    if(data.isEmpty())
        return false;
    while(!data.isEmpty())
    {
        c = data.at(data.size()-1);
        if((c=='\n')||(c=='\r')||(c=='\0'))
            data.chop(1);
        else
            break;
    }
    return true;
}

bool QIODeviceHelper::readLnASCII(QString& dstString)
{
    QByteArray data;
    if(!readLn(data))
        return false;
    dstString = QString::fromAscii(data.constData());
    return true;
}

bool QIODeviceHelper::readLnUTF8(QString& dstString)
{
    QByteArray data;
    if(!readLn(data))
        return false;
    dstString = QString::fromUtf8(data.constData());
    return true;
}

bool QIODeviceHelper::writeLnASCII(const QString& dstString)
{
    QByteArray data = dstString.toAscii();
    data.append('\n');
    return ((QIODevice*)this)->write(data) == data.size();
}

bool QIODeviceHelper::writeLnUTF8(const QString& dstString)
{
    QByteArray data = dstString.toUtf8();
    data.append('\n');
    return ((QIODevice*)this)->write(data) == data.size();
}

QStringList QIODeviceHelper::readLinesASCII()
{
    QStringList lines;
    QString line;
    while(readLnASCII(line))
        lines.append(line);
    return lines;
}

QStringList QIODeviceHelper::readLinesUTF8()
{
    QStringList lines;
    QString line;
    while(readLnUTF8(line))
        lines.append(line);
    return lines;
}

bool QIODeviceHelper::writeLinesASCII(const QStringList& lines)
{
    foreach(QString line, lines)
    {
        if(!writeLnASCII(line))
            return false;
    }
    return true;
}

bool QIODeviceHelper::writeLinesUTF8(const QStringList& lines)
{
    foreach(QString line, lines)
    {
        if(!writeLnUTF8(line))
            return false;
    }
    return true;
}

bool QIODeviceHelper::writeInt(qint8 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(quint8 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(qint16 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(quint16 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(qint32 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(quint32 value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(const qint64& value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

bool QIODeviceHelper::writeInt(const quint64& value)
{
    return ((QIODevice*)this)->write((char*)&value, sizeof(value)) == sizeof(value);
}

qint8 QIODeviceHelper::readInt8()
{
    qint8 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

quint8 QIODeviceHelper::readUint8()
{
    quint8 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

qint16 QIODeviceHelper::readInt16()
{
    qint16 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

quint16 QIODeviceHelper::readUint16()
{
    quint16 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

qint32 QIODeviceHelper::readInt32()
{
    qint32 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

quint32 QIODeviceHelper::readUint32()
{
    quint32 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

qint64 QIODeviceHelper::readInt64()
{
    qint64 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}

quint64 QIODeviceHelper::readUint64()
{
    quint64 value;
    ((QIODevice*)this)->read((char*)&value, sizeof(value));
    return value;
}
