import sys
import dbus
from dbus.mainloop.glib import DBusGMainLoop

class Notifier:

	def __init__(self):
		self.dbus_loop = DBusGMainLoop(set_as_default=True)
		self.bus = dbus.SessionBus(mainloop=self.dbus_loop)
		self.provider = self.bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		self.proxy = dbus.Interface(self.provider, 'org.freedesktop.Notifications') 
		
	def showAlert(self,alertText):
		self.proxy.SystemNoteDialog(alertText, 0 ,"ok")
	
	def requestPatience(self):
		text = "Please Wait"
		self.proxy.SystemNoteInfoprint(text)
		
	
	def showSuccess(self, num):
		text = "Successfuly Imported "+str(num)+" messages"
		self.proxy.SystemNoteDialog(text, 0 ,"ok")
		
	def showFailure(self):
		text = "Failed to import messages"
		self.proxy.SystemNoteDialog(text, 0 ,"ok")
		
