import csv
from recv import recv
from sent import sent
from contactsServ import *
import os

class csvServ:

	def __init__(self):
	
		
		self.pathToHome = "/home/user/"
		self.pathToApp = self.pathToHome+".retroconv/"
		self.pathToInbox = self.pathToApp+"inbox.csv"
		self.pathToSent = self.pathToApp+"sent.csv"
			
		self.recvLst=[]
		self.sentLst=[]
		self.recvNumbers=[]
		self.sentNumbers=[]
		
		self.checkInitialLaunch()
		
	def checkInitialLaunch(self):
		if not os.path.isdir(self.pathToApp):
			os.system("mkdir "+self.pathToApp)
		
		
	
	
	def checkFileValidity(self):
		print "Checking validity"
		
		#Check Extra Lines
		#Check number of fields
		#Check submit, deliver, sms (constant fields)
		
	def fetchInbox(self):
		ifile = open(self.pathToInbox, "r")
		reader=csv.reader(ifile)
		del self.recvLst[:]
		#self.recvLst=[]
		#self.recvNumbers=[]
		i = 0;
		for row in reader:
			
			if row[1] == "deliver":
				self.recvLst.append(recv(row[2],row[5], row[7]))
				self.recvNumbers.append(row[2][-7:])
			
		
		
		ifile.close()
		
	def fetchSent(self):
		ifile = open(self.pathToSent, "r")
		reader=csv.reader(ifile)
		del self.sentLst[:]
		#self.sentLst=[]
		#self.sentNumbers=[]
		for row in reader:
			if row[1] == "submit":
				self.sentLst.append(sent(row[3],row[5], row[7]))
				self.sentNumbers.append(row[3][-7:])
		
		
		
		
		
		ifile.close()
	
	def fetchContactsInfo(self):
		abook=address_book()
		abook.populateNames(self.recvLst, self.sentLst)
	
	def hasImportedSent(self):
		 return os.path.isfile (self.pathToSent)
		 	
		 
	def hasImportedInbox(self):
		 return os.path.isfile (self.pathToInbox)
		 	
		
	def importSent(self, path):
		try:
			#if hasImportedSent:
			#	os.system("rm "+self.pathToSent)
				
			os.system("cp "+str(path).replace(" ", "\ ")+ " "+self.pathToSent)
			self.fetchSent()
			return True
		except:
			return False
	
	def importInbox(self, path):
		try:
			#if hasImportedInbox:
			#	os.system("rm "+self.pathToInbox)
				
			os.system("cp "+str(path).replace(" ", "\ ")+ " "+self.pathToInbox)
			self.fetchInbox()
			return True
		except:
			return False
				
		
	def getAllReceivedMsgs(self):
		msgs=[]
		for msg in self.recvLst:
			msgs.append(msg.getSummary())
		return msgs
		
	
	
	
	def getMsg(self, msgNum, msgType = 0):
		#msgType 0: recv, 1:sent
		
		if msgType == 0:
			return self.recvLst[msgNum]
		
		return self.sentLst[msgNum]
		
	
	def getMsgText(self, msgNum):
		return self.recvLst[msgNum].getMsg()
