#Run it manually:
# cd /usr/lib/hildon-desktop
# python2.5 recaller.py

import gtk
import pygtk
import hildon
import hildondesktop
import dbus
import os
import time 
import gobject

import pygst
pygst.require("0.10")
import gst


class RecallerHomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    
    #Draw the widget button
    self.recbutton = gtk.ToggleButton("REC")
    self.recbutton.set_size_request(64,64) 
    self.recbutton.connect("toggled", self.on_toggled, 15)
    self.recbutton.show_all()

    hbox = gtk.HBox(True) 
    hbox.pack_start(self.recbutton)
    self.add(hbox) 
    self.set_opacity(0.5)
    hbox.show()

    self.fileName = "/home/user/MyDocs/initDummy.aac"
    self.player = gst.parse_launch ("adder name=theAdder ! nokiaaacenc bitrate=128000 output-format=2 ! filesink location=%s. pulsesrc device=sink.hw0.monitor ! queue ! theAdder. pulsesrc device=source.hw0 ! queue ! theAdder." % self.fileName)
    bus = self.player.get_bus()
    bus.add_signal_watch()
    bus.enable_sync_message_emission()
    bus.connect('message', self.on_message)
    #bus.connect('sync-message::element', self.on_sync_message)
    
  def on_toggled(self, button, data):
    if button.get_active()==True:
      #Button got activated, start the recording
      self.startTime =  time.strftime("%Y%m%d_%H%M%S")
      self.fileName = "/home/user/MyDocs/Rec_%s.aac" % self.startTime
      print self.fileName
      self.player = gst.parse_launch ("adder name=theAdder ! nokiaaacenc bitrate=128000 output-format=2 ! filesink location=%s. pulsesrc device=sink.hw0.monitor ! queue ! theAdder. pulsesrc device=source.hw0 ! queue ! theAdder." % self.fileName)
      self.player.set_state(gst.STATE_PLAYING)
      banner = hildon.hildon_banner_show_information(self, "", "recaller: Conversation recording has started.")
      banner.set_timeout(2000)
      print "recaller: " + time.strftime("%H:%M:%S") + " - Conversation started."
    else:
      #Button got deactivated. stop the recording
      self.player.set_state(gst.STATE_NULL)
      finalName = "/home/user/MyDocs/Rec_%s-%s.aac" % (self.startTime, time.strftime("%H%M%S"))
      print finalName 
      time.sleep(2)
      os.rename(self.fileName, finalName)
      banner = hildon.hildon_banner_show_information(self, "", "recaller: Conversation recording was stopped.")
      banner.set_timeout(2000)
      print "recaller: " + time.strftime("%H:%M:%S") + " - Conversation stopped."   

  def on_message(self, bus, message):
    t = message.type
    if t == gst.MESSAGE_EOS:
      self.player.set_state(gst.STATE_NULL)
    elif t == gst.MESSAGE_ERROR:
      self.player.set_state(gst.STATE_NULL)
    #err, debug = message.parse_error()
    #print "recaller on_message: %s" % err, debug
    #banner = hildon.hildon_banner_show_information(self, "", "recaller: " + message.parse_error())
    #banner.set_timeout(2000)  

  def on_sync_message(self, bus, message):
    if message.structure is None:
      return
    message_name = message.structure.get_name()
    if message_name == 'prepare-xwindow-id':
      return
      # Assign the viewport
      #imagesink = message.src
      #imagesink.set_property('force-aspect-ratio', True)
      #imagesink.set_xwindow_id(self.movie_window.window.xid)
         
hd_plugin_type = RecallerHomePlugin

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

    