/*
 * Simple DBus routines to share links.
 * Copyright (c) 2009 Thomas Thurman
 * thomas@thurman.org.uk
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have be able to view the GNU General Public License at 
 * http://www.gnu.org/copyleft/gpl.html ; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SHARING_H
#define SHARING_H 1

#include <gtk/gtk.h>

/**
 * Puts up a selector to let the user choose how to share a link.
 *
 * \param window  The parent for the selector.
 * \param link    The link.
 * \param title   The title of the link.
 */
void
sharing_choice (GtkWindow *window,
		char *link,
		char *title);

#endif
