/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef TYPESWINDOW_H
#define TYPESWINDOW_H

#include "BaseWindow.h"

class QCheckBox;
class QPushButton;

namespace Windows
{
	class TypesWindow : public BaseWindow
	{
		Q_OBJECT

	public:
		explicit TypesWindow(Settings& settings, QWidget *parent = 0);

	protected slots:
		void Continue();
		void OrientationChanged();

	private:
		void CreateContents();
		void Advance();

	private:
		QCheckBox *cbMadeCalls;
		QCheckBox *cbRecvCalls;
		QCheckBox *cbSentSMS;
		QCheckBox *cbRecvSMS;
		QCheckBox *cbSentMMS;
		QCheckBox *cbRecvMMS;
		QCheckBox *cbSentChat;
		QCheckBox *cbRecvChat;
		QPushButton *btnContinue;
	};
}
#endif // TYPESWINDOW_H
