/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "TypesWindow.h"
#include "DirectoryWindow.h"

#include <QtGui>

using namespace Windows;

TypesWindow::TypesWindow(Settings& settings, QWidget *parent) :
	BaseWindow(settings, parent)
{
	CreateContents();
}

void TypesWindow::CreateContents()
{
	switch(CurrentSettings().AppMode())
	{
		case Settings::APPMODE_GUI:
		{
			QWidget *layoutWidget = new QWidget(centralWidget());
			layoutWidget->setGeometry(QRect(0, 0, 801, 251));

			QGridLayout *layout = new QGridLayout(layoutWidget);
			{
				layout->setSizeConstraint(QLayout::SetMaximumSize);
				layout->setContentsMargins(0, 0, 0, 0);

				// Spacers
				{
					// Vertical 1
					layout->addItem(
						new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding),
						6., 2, 1, 1);

					// Vertical 2
					layout->addItem(
						new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::MinimumExpanding),
						0, 2, 1, 1);

					// Horzontal 1
					layout->addItem(
						new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum),
						0, 4, 1, 1);

					// Horizontal 2
					layout->addItem(
						new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum),
						0, 0, 1, 1);
				}

				// Set up columns
				layout->setColumnStretch(0, 3);
				layout->setColumnStretch(1, 1);
				layout->setColumnStretch(2, 1);
				layout->setColumnStretch(3, 1);
				layout->setColumnStretch(4, 4);

				int row = 1;

				// Begin Headings
				{
					QLabel *lblSent = new QLabel();
					lblSent->setText(tr("Sent"));
					lblSent->setAlignment(Qt::AlignCenter);
					layout->addWidget(lblSent, row, 2, 1, 1);
				}
				{
					QLabel	*lblReceived = new QLabel();
					lblReceived->setText(tr("Recieved"));
					lblReceived->setAlignment(Qt::AlignCenter);
					layout->addWidget(lblReceived, row, 3, 1, 1);
				}
				++row;
				// End Headings

				QSizePolicy sizePolicyForCheckBoxes(QSizePolicy::Minimum, QSizePolicy::Minimum);
				sizePolicyForCheckBoxes.setHorizontalStretch(0);
				sizePolicyForCheckBoxes.setVerticalStretch(0);
				sizePolicyForCheckBoxes.setHeightForWidth(false);

				// Calls
				{
					QLabel *lblCalls = new QLabel();
					lblCalls->setText(tr("Calls"));
					lblCalls->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
					layout->addWidget(lblCalls, row, 1, 1, 1);
				}
				{
					cbMadeCalls = new QCheckBox();
					cbMadeCalls->setEnabled(false);
					cbMadeCalls->setSizePolicy(sizePolicyForCheckBoxes);
					cbMadeCalls->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbMadeCalls, row, 2, 1, 1);
				}
				{
					cbRecvCalls = new QCheckBox();
					cbRecvCalls->setEnabled(false);
					cbRecvCalls->setSizePolicy(sizePolicyForCheckBoxes);
					cbRecvCalls->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbRecvCalls, row, 3, 1, 1);
				}
				++row;
				// End Calls

				// SMS
				{
					QLabel *lblSMS = new QLabel();
					lblSMS->setText(tr("SMS"));
					lblSMS->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
					layout->addWidget(lblSMS, row, 1, 1, 1);
				}
				{
					cbSentSMS = new QCheckBox();
					cbSentSMS->setSizePolicy(sizePolicyForCheckBoxes);
					cbSentSMS->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbSentSMS, row, 2, 1, 1);
				}
				{
					cbRecvSMS = new QCheckBox();
					cbRecvSMS->setSizePolicy(sizePolicyForCheckBoxes);
					cbRecvSMS->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbRecvSMS, row, 3, 1, 1);
				}
				++row;
				// End SMS

				// MMS
				{
					QLabel	*lblMMS = new QLabel();
					lblMMS->setText(tr("MMS"));
					lblMMS->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
					layout->addWidget(lblMMS, row, 1, 1, 1);
				}
				{
					cbSentMMS = new QCheckBox();
					cbSentMMS->setEnabled(false);
					cbSentMMS->setSizePolicy(sizePolicyForCheckBoxes);
					cbSentMMS->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbSentMMS, row, 2, 1, 1);
				}
				{
					cbRecvMMS = new QCheckBox();
					cbRecvMMS->setEnabled(false);
					cbRecvMMS->setSizePolicy(sizePolicyForCheckBoxes);
					cbRecvMMS->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbRecvMMS, row, 3, 1, 1);
				}
				++row;
				// End MMS

				// Chat
				{
					QLabel	*lblChat = new QLabel();
					lblChat->setText(tr("Chat"));
					lblChat->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
					layout->addWidget(lblChat, row, 1, 1, 1);
				}
				{
					cbSentChat = new QCheckBox();
					cbSentChat->setEnabled(false);
					cbSentChat->setSizePolicy(sizePolicyForCheckBoxes);
					cbSentChat->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbSentChat, row, 2, 1, 1);
				}
				{
					cbRecvChat = new QCheckBox();
					cbRecvChat->setEnabled(false);
					cbRecvChat->setSizePolicy(sizePolicyForCheckBoxes);
					cbRecvChat->setMaximumSize(QSize(70, 64));
					layout->addWidget(cbRecvChat, row, 3, 1, 1);
				}
				++row;
				// End Chat

				// Continue button
				{
					btnContinue = new QPushButton(centralWidget());
					btnContinue->setText(tr("Continue..."));
					{
						QSizePolicy sizePolicyForContinueButton(QSizePolicy::Fixed, QSizePolicy::Fixed);
						sizePolicyForContinueButton.setHorizontalStretch(0);
						sizePolicyForContinueButton.setVerticalStretch(0);
						sizePolicyForContinueButton.setHeightForWidth(true);
						btnContinue->setSizePolicy(sizePolicyForContinueButton);
					}
					QObject::connect(btnContinue, SIGNAL(clicked()), this, SLOT(Continue()));
				}

				connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(OrientationChanged()));
				OrientationChanged();

				centralWidget()->setLayout(layout);
			}

			break;
		}

		case Settings::APPMODE_CONSOLE:
		{
			// Process args.

			Advance();
			break;
		}
	}
}

void TypesWindow::OrientationChanged()
{
	QRect screenGeometry = QApplication::desktop()->screenGeometry();
	// Landscape
	if (screenGeometry.width() > screenGeometry.height())
		btnContinue->setGeometry(QRect(610, 340, 184, 80));
	// Portrait
	else
		btnContinue->setGeometry(QRect(290, 655, 184, 80));
}

void TypesWindow::Continue()
{
	CurrentSettings().setShouldProcess(Settings::TYPE_SENT, Settings::EVENTTYPE_SMS, cbSentSMS->checkState() == Qt::Checked);
	CurrentSettings().setShouldProcess(Settings::TYPE_SENT, Settings::EVENTTYPE_MMS, cbSentMMS->checkState() == Qt::Checked);
	CurrentSettings().setShouldProcess(Settings::TYPE_SENT, Settings::EVENTTYPE_CHAT, cbSentChat->checkState() == Qt::Checked);
	CurrentSettings().setShouldProcess(Settings::TYPE_RECIEVED, Settings::EVENTTYPE_SMS, cbRecvSMS->checkState() == Qt::Checked);
	CurrentSettings().setShouldProcess(Settings::TYPE_RECIEVED, Settings::EVENTTYPE_MMS, cbRecvMMS->checkState() == Qt::Checked);
	CurrentSettings().setShouldProcess(Settings::TYPE_RECIEVED, Settings::EVENTTYPE_CHAT, cbRecvChat->checkState() == Qt::Checked);

	if(CurrentSettings().anyToProcess())
		Advance();
	else
		QMessageBox::critical(this, tr("Excuse me"), tr("You must select at least one type of data to process."));
}

void TypesWindow::Advance()
{
	QWidget* next = new DirectoryWindow(CurrentSettings(), this);
	next->show();
}
