/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "DirectoryWindow.h"

#include <QtGui>

using namespace Windows;

DirectoryWindow::DirectoryWindow(Settings& settings, QWidget *parent) :
		BaseWindow(settings, parent)
{
	CreateContents();
}

void DirectoryWindow::CreateContents()
{
	switch(CurrentSettings().AppMode())
	{
		case Settings::APPMODE_GUI:
		{
			QVBoxLayout *layout = new QVBoxLayout();
			{
		//		QLabel* lblTest = new QLabel(CurrentSettings().Directory());
		//		layout->addWidget(lblTest);
		//		//layout->setAlignment(lblTest, Qt::AlignHCenter | Qt::AlignTop);

				QPushButton* btnChoose = new QPushButton(QIcon(":/resources/sphone.png"), tr("Choose data directory"));
				QObject::connect(btnChoose, SIGNAL(clicked()), this, SLOT(Choose()));
				layout->addWidget(btnChoose);
				layout->setAlignment(btnChoose, Qt::AlignHCenter);

		//		layout->addWidget(new QLabel());

				centralWidget()->setLayout(layout);
			}

			break;
		}

		case Settings::APPMODE_CONSOLE:
		{
			// Process args.

			Advance();
			break;
		}
	}
}

void DirectoryWindow::Choose()
{
	CurrentSettings().setDirectory(QFileDialog::getExistingDirectory(
		this,
		"Data directory",
		QDir::homePath() + "/MyDocs",
		QFileDialog::ShowDirsOnly ));
//	if(CurrentSettings().Mode() == Settings::MODE_IMPORT)
//		CurrentSettings().setDirectory(QDir::homePath() + "/MyDocs/sms/");
//	else
//		CurrentSettings().setDirectory(QDir::homePath() + "/MyDocs/tmp/");
	Advance();
}

void DirectoryWindow::Advance()
{
	CurrentSettings().setConfirmed(true);
	close();
}
