/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef BASEWINDOW_H
#define BASEWINDOW_H

#include <QMainWindow>

#include "Settings.h"

namespace Windows
{
	class BaseWindow : public QMainWindow
	{
		Q_OBJECT

	private:
		Settings& m_Settings;
		QWidget* m_Parent;

	protected:
		Settings& CurrentSettings() const { return m_Settings; }
		const Settings& setCurrentSettings(Settings& settings) { return m_Settings = settings; }
		QWidget* Parent() const { return m_Parent; }

	public:
		explicit BaseWindow(Settings& settings, QWidget *parent = 0);
		virtual ~BaseWindow();

	protected slots:
		void About();
		void AboutQt();

	protected:
		virtual void closeEvent(QCloseEvent *);

	private:
		QMenu *m_HelpMenu;
		void CreateMenus();

		QAction *m_AboutAct;
		QAction *m_AboutQtAct;
		void CreateActions();

		void CreateContents();
	};
}
#endif // BASEWINDOW_H
