/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "BaseWindow.h"

#include <QtGui>

using namespace Windows;

BaseWindow::BaseWindow(Settings& settings, QWidget *parent) :
	QMainWindow(parent),
	m_Settings(settings),
	m_Parent(parent)
{
	setWindowIcon(QIcon(":/resources/sphone.png"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
	this->setAttribute(Qt::WA_DeleteOnClose);
	this->setWindowTitle("QwerkiSync");
	this->setWindowIcon(QIcon(":/resources/sphone.png"));

	CreateActions();
	CreateMenus();
	CreateContents();
}

BaseWindow::~BaseWindow()
{
}

void BaseWindow::closeEvent(QCloseEvent *)
{
	if(Parent() != NULL && CurrentSettings().IsConfirmed())
		Parent()->close();
}

void BaseWindow::CreateMenus()
{
	m_HelpMenu = menuBar()->addMenu(tr("&Help"));
	m_HelpMenu->addAction(m_AboutAct);
	m_HelpMenu->addAction(m_AboutQtAct);
}

void BaseWindow::CreateActions()
{
	m_AboutAct = new QAction(QIcon(":/resources/sphone.png"), tr("&About"), this);
	m_AboutAct->setStatusTip(tr("Show the application's About box"));
	m_AboutAct->setIconVisibleInMenu(true);
	connect(m_AboutAct, SIGNAL(triggered()), this, SLOT(About()));

	m_AboutQtAct = new QAction(tr("&About Qt"), this);
	m_AboutQtAct->setStatusTip(tr("Qt"));
	connect(m_AboutQtAct, SIGNAL(triggered()), this, SLOT(AboutQt()));
}

void BaseWindow::CreateContents()
{
	QWidget *central = new QWidget(this);
	setCentralWidget(central);
}

void BaseWindow::About()
{
	QMessageBox::about(this, "about", "about me");
}

void BaseWindow::AboutQt()
{
	QMessageBox::aboutQt(this, tr("About Qt"));
}
