/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPREVENTER_H
#define EVENTPREVENTER_H

class Settings;

class QString;
#include <QHash>

class EventPreventer
{
public:
	EventPreventer(const Settings &settings);
	~EventPreventer();

public:
	void StoreAccountStates();
	void DisableAccounts();
	void EnableAccounts();
	void RestoreAccounts();

private:
	void SetAccountsToSameState(const bool desiredState);
	void SetAccountToState(const QString &accountPath, const bool desiredState);

public:
	const QHash<QString, bool> & OriginalAccountStates() const { return m_OriginalAccountStates; }
	QHash<QString, bool> & OriginalAccountStates() { return m_OriginalAccountStates; }
	void setOriginalAccountStates(const QHash<QString, bool> originalAccountStates) { m_OriginalAccountStates = originalAccountStates; }

protected:
	const Settings & CurrentSettings() const { return m_Settings; }

private:
	const Settings & m_Settings;
	QHash<QString, bool> m_OriginalAccountStates;
};

#endif // EVENTPREVENTER_H
