/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTLOGBACKUPMANAGER_H
#define EVENTLOGBACKUPMANAGER_H

class Settings;

#include <QFileInfoList>
#include <QString>

class EventLogBackupManager
{
public:
	EventLogBackupManager(const Settings & currentSettings);
	~EventLogBackupManager();

	void CreateBackup();
	void RestoreBackup(const QString &backup);

	void LockCurrentBackup();
	void UnlockCurrentBackup();

	void LockBackup(const QString &backupPath);
	void UnlockBackup(const QString &backupPath);

	void PurgeOldBackups();
	void EnsureBackupValid(const QString &backupPath);

public:
	const QString & BackupDirectoryPath() const { return m_BackupDirectoryPath; }
	void setBackupDirectoryPath(const QString & backupDirectoryPath) { m_BackupDirectoryPath = backupDirectoryPath; }
	const QString & DataDirectoryPath() const { return m_DataDirectoryPath; }
	void setDataDirectoryPath(const QString & dataDirectoryPath) { m_DataDirectoryPath = dataDirectoryPath; }
	const QString & CurrentBackupName() const { return m_CurrentBackupName; }
	void setCurrentBackupName(const QString & currentBackupName) { m_CurrentBackupName = currentBackupName; }
	const QString & LockFilename() const { return m_LockFilename; }
	void setLockFilename(const QString & lockFilename) { m_LockFilename = lockFilename; }
	const uint & MaxNumberOfBackups() const { return m_MaxNumberOfBackups; }
	void setMaxNumberOfBackups(const uint maxNumberOfBackups) { m_MaxNumberOfBackups = maxNumberOfBackups; }
	const QString CurrentBackupPath() const { return BackupDirectoryPath() + CurrentBackupName(); }
	const QFileInfoList CurrentBackups(bool lockedOnly);
	const Settings & CurrentSettings() const { return m_kCurrentSettings; }

private:
	void RemoveDirRecusively(const QFileInfo &dirInfo);

private:
	QString m_BackupDirectoryPath;
	QString m_DataDirectoryPath;
	QString m_CurrentBackupName;
	QString m_LockFilename;
	uint m_MaxNumberOfBackups;
	const Settings & m_kCurrentSettings;
};

#endif // EVENTLOGBACKUPMANAGER_H
