/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_FMMS_H
#define DBBACKENDS_FMMS_H

#include "iDBBackend.h"

namespace EventTypes { class iEvent; class FmmsEvent; }
class Settings;

template <typename T1> class QList;

namespace DBBackends
{
	class Fmms : public iDBBackend
	{
	public:
		Fmms(const Settings &settings);
		Fmms(const Settings &settings, const EventTypes::FmmsEvent &event);

		virtual void Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup);
		virtual void Process(EventProcessors::iEventProcessor &eventProcessor);

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }

	protected:
		virtual EventTypes::iEvent *const CreateEvent(int &fevent, QList<void*> &fattachments);

	private:
		const Settings &m_Settings;
	};
}

#endif // DBBACKENDS_FMMS_H
